package Intapi::BalanceRevise;

use Direct::Modern;

use Settings;

use Yandex::DBTools;
use Yandex::ListUtils qw/nsort/;


our $MIN_AGE = '60 MINUTE';


=head2 new
=cut

sub new {
    return bless {};
}

=head2 getPaidCidsNotInBS

Возвращает список кампаний, которые оплачены, но не доехали до БК

Пример вызова:

curl -sd '{"method":"getPaidCidsNotInBS"}' http://8222.beta1.direct.yandex.ru/jsonrpc/BalanceRevise | json_pp

=cut

sub getPaidCidsNotInBS {
    my ($self, $params, $procedure, @extra_args) = @_;

    my $cids = get_one_column_sql(PPC(shard=>'all'), [
            'SELECT cid  FROM campaigns c',
            WHERE => {
                OrderID => 0,
                LastChange__lt__dont_quote => "now() - interval $MIN_AGE",
                sum__gt__dont_quote => 'sum_spent',
            },
#            LIMIT => 1,
        ]);

    return { result => [ nsort @$cids ] };
}

1;
