package Intapi::CLegacy::ClientInfo;

# curl -d '{"method": "user_info", "params":{"uid": 13}}' https://8998.beta1.direct.yandex.ru/jsonrpc/CLegacyClientInfo


use strict;
use warnings;

use Carp;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use RBACElementary;
use PrimitivesIds;
use Surveys;
use Campaign::Types qw/get_camp_kind_types/;


sub new { bless {} }



=head2 user_info

title: информация о клиенте
description: |
  получение параметров логина:
  * роль и доп. флаги прав
  * шард
  * наличие кампаний
  * логин главного представителя

param:
  properties:
    uid:
      type: integer
  required: [uid]

result:
  properties:
    role: {}
    shard: {}
    client_chief_login: {}
    has_campaigns: {}
    is_any_client: {}
    is_teamleader: {}
    is_superteamleader: {}
    is_any_teamleader: {}
    is_super_placer: {}
    is_super_media_planner: {}
    is_agency_chief: {}
    is_agency_main: {}
    is_agency_limited: {}
    is_client_chief: {}
    is_internal_user: {}
    is_developer: {}
    is_super_manager: {}
  required: [role]

=cut

sub user_info {
    my ($self, $param) = @_;
    my $uid = $param->{uid};
    die {code => 'InvalidParams', message => "Need <uid>"}  if !$uid;

    my $ret = rbac_who_is_detailed(undef, $uid);

    if ($ret->{role} eq 'client') {
        my $chief_uid = rbac_get_chief_rep_of_client_rep($uid);
        $ret->{client_chief_login} = get_login(uid => $chief_uid);
        my $shard = $ret->{shard} = get_shard(uid => $chief_uid);
        $ret->{has_campaigns} = get_one_field_sql(PPC(shard => $shard),
            ["SELECT 1  FROM campaigns",
             where => {uid => $chief_uid,
                       type=>get_camp_kind_types('web_edit_base'),
                       statusEmpty__ne=>'Yes',
                       }
            ]
        );
    } else {
        $ret->{shard} = get_shard(uid => $uid);
        $ret->{has_campaigns} = 0;
        if ($ret->{role} eq 'superreader') {
            my $sr_flags = get_one_line_sql(PPC(shard => $ret->{shard}),
                'SELECT is_developer, is_super_manager FROM internal_users WHERE uid=? LIMIT 1',
                $uid
            );
            $ret->{is_developer} = 1  if $sr_flags->{is_developer} && $sr_flags->{is_developer} eq 'Yes';
            $ret->{is_super_manager} = 1 if $sr_flags->{is_super_manager};
        }
    }

    return $ret;
}



=head2 get_surveys

title: список активных опросов
description: |
    по указанному uid выдать список активных опросов для пользователя

param:
  properties:
    uid:
      type: integer
      description: идентификатор пользователя
  reqired: [uid]

result: 
  properties:
    surveys:
      type: array
      description: список опросов, может быть пустым
      items:
        type: object
        properties:
          survey_id:
            type: integer
          title:
            type: string
          url:
            type: string
            format: uri
          
  reqired: [surveys]

=cut

sub get_surveys  {
    my ($self, $param) = @_;
    my $uid = $param->{uid};
    die {code => 'InvalidParams', message => "Need <uid>"}  if !$uid;

    my $surveys = Surveys::get_user_active_surveys($uid);

    return { surveys => $surveys };
}


1;
