package Intapi::CLegacy::RBAC;

=head1 NAME

    rbac - кокаиновое приложение для работы с системой прав и ролей

=head1 DESCRIPTION
    
curl -d '{"method": "get_infoblock_rights", "params":{"UID": 123, "uid":1234}}' https://8998.beta1.direct.yandex.ru/jsonrpc/CLegacyRBAC

=cut

use strict;
use warnings;

use Carp;
use JSON;

use Settings;

use RBACElementary;
use RBACDirect;


sub new { bless {} }


=head2 get_infoblock_rights

title: получение прав на операции с инфоблоком
description: Получение прав на операции с инфоблоком

param:
  properties:
    UID:
      type: integer
      description: идентификатор оператора (чьи права спрашиваем)
    uid:
      type: integer
      description: идентификатор клиента (с чьим инфоблоком работаем)
  reqired: [UID, uid]

result: 
  properties:
    can_view:
      type: bool
      description: можно просматривать
    can_edit:
      type: bool
      description: можно редактировать
  reqired: [can_view, can_edit]

=cut

sub get_infoblock_rights {
    my ($self, $params) = @_;
    my ($UID, $uid) = @{$params}{qw/UID uid/};

    die {code => 'InvalidParams', message => "Need <UID>"}  if !$UID;
    die {code => 'InvalidParams', message => "Need <uid>"}  if !$uid;

    my ($can_view, $can_edit);
    if ($UID == $uid) {
        ($can_view, $can_edit) = (1, 1);
    } elsif (rbac_is_owner(undef, $UID, $uid)) {
        $can_view = 1;
        my $operator_info = rbac_who_is_detailed(undef, $UID);
        $can_edit = $operator_info->{role} eq 'manager' && !$operator_info->{is_any_teamleader}
                    || !$operator_info->{is_internal_user};
    }

    return {
            can_view => $can_view ? JSON::true : JSON::false,
            can_edit => $can_edit ? JSON::true : JSON::false,
    };
}


1;
