package Intapi::CSRF;

=head1 NAME


=head1 DESCRIPTION
    Модуль с ф-циями для получения csrf-токена по UID'у, для использования в контроллерах.

=cut

use Direct::Modern;
use CSRFCheck qw//;
use Yandex::Validate qw/is_valid_int/;

=head2 new

=cut

sub new {
    bless {};
}
    
    

=head2 get_csrf_token
    По UID'у отдаёт csrf-токен

    На входе: $UID
    На выходе: $csrf_token
=cut

=head2 check_csrf_token
    Проверяет csrf-токен
=cut


sub get_csrf_token {
    my ($class, $params) = @_;

    my $UID = $params->{UID};
    if (!is_valid_int($UID, 1)){
        die {message => 'UID must be positive integer'}
    }

    my $csrf_token = CSRFCheck::get_csrf_token($UID);
    return {csrf_token => $csrf_token};
}

sub check_csrf_token {
    my ($class, $params) = @_;
    my $UID = $params->{UID};
    my $csrf_token = $params->{csrf_token};
    my $result = CSRFCheck::check_csrf_token($csrf_token, $UID);
    return $result;
}
1;
