package Intapi::CampaignTypesList;

use strict;
use warnings;


use Campaign::Types;
use JSON;
use utf8;


=head2 handler
  Возвращает хэш из "надтипов" и соответствующих им типов
  Принимает именованные параметры:
    - pretty. Задает, надо ли форматировать(pretty-print) Json.
  curl -s 'https://10070.beta3.direct.yandex.ru/CampaignTypesList?pretty=1'
  {
      "camp_types" : {
          "api5_edit" : [
              "dynamic",
              "mobile_content",
              "text"
          ],
          "non_currency_convert" : [
              "geo",
              "mcb"
          ]
      }
  }
=cut

sub handler {
    my ($r, $multiform) = @_;
    my %camp_types;
    for my $camp_type (keys %Campaign::Types::KINDS) {
        $camp_types{$camp_type} = get_camp_kind_types($camp_type);
    }
    my $coder = JSON->new()->pretty($multiform->{pretty} ? 1 : 0);
    return {text => $coder->encode({camp_types => \%camp_types}), content_type => "text/x-javascript"};
}

1;
