package Intapi::CampaignsCopy;

=head1 NAME

    Intapi::CampaignsCopy

=head1 DESCRIPTION

=cut

use Direct::Modern;
use Yandex::I18n;

use Campaign::CopyWithinClient;

use JSON;


=head2 handler

    Ручка копирования кампаний

=cut

sub handler
{
    my ($r, $multiform) = @_;

    my $param = JSON::from_json($r->content, { utf8 => 1 });

    my $lang = $param->{lang} || Yandex::I18n::default_lang();
    my $lang_guard = Yandex::I18n::init_i18n_guard($lang);

    my $cids = $param->{cids};
    my $operator_uid = $param->{operator_uid};
    my $client_id_from = $param->{client_id_from};
    my $client_id_to = $param->{client_id_to};
    my $sync = $param->{sync} ? 1 : 0;

    if ($client_id_from != $client_id_to) {
        return {
            json => {
                success => 0,
                error => "Interclient copy not supported",
            },
        };
    }

    my $result = Campaign::CopyWithinClient::copy_camps($cids, $operator_uid, $client_id_from, sync => $sync);

    if (!$result->{result}) {
        my $error = "Unknown copy error";

        if ($result->{validation_error}) {
            $error = $result->{validation_error};
        } elsif ($result->{copy_error}) {
            $error = $result->{copy_error};
        }

        return {
            json => {
                success => 0,
                error => $error,
            },
        };
    }

    return {
        json => {
            success => 1,
            $result->{cid} ? (cid => $result->{cid}) : ()
        },
    };
}

1;
