package Intapi::CampaignsForMetrica;

#    $Id$

=head1 NAME

    intapi/campaignsformetrica

=head1 DESCRIPTION

    Получение списка кампаний и доменов для метрики по uid'у одного из представителей клиента

    Принимает именованные параметры:
    uid
    empty_domain_is_ok => 1/0 [опционально, по-умолчанию 0]

=cut

use strict;
use warnings;

use Settings;

use Yandex::Blackbox;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Validate;

use HttpTools;
use RBAC2::Extended;
use RBACElementary;
use YAML::Syck();
use Campaign::Types ();

use utf8;


sub handler 
{
    my ($r, $multiform) = @_;

    my $form = multiform2directform($multiform);

    my %param = %$form;

    my $uid = $param{uid};
    return export_error(404, "Invalid uid") unless is_valid_id($uid);

    my $bb_res = eval { bb_userinfo($uid, $r->address, 'direct.yandex.ru', [$BB_SUID_DIRECT]) };
    
    return export_error(500, $@) if $@;
    return export_error(404, "Invalid uid") if !$bb_res->{uid};

    # делаем выборку из базы только если человек заходил в Директ
    my $data = [];
    if ($bb_res->{dbfield}->{$BB_SUID_DIRECT}) {
        my $rbac = RBAC2::Extended->get_singleton($uid);
        my $chief_uid = rbac_get_chief_rep_of_client_rep($uid);

        # выбираем
        my $sql = [
            q{
                SELECT c.cid, c.OrderID, c.name, c.shows, b.domain, ifnull(fd.filter_domain, b.domain) as fil
                FROM campaigns c 
                JOIN phrases p USING(cid)
                JOIN banners b USING(pid)
                LEFT JOIN filter_domain fd ON b.domain = fd.domain 
            },
            WHERE => {
                'c.type'                => Campaign::Types::get_camp_kind_types('direct_links_in_ads'),
                'c.uid'                 => SHARD_IDS,
                'c.statusEmpty'         => 'No',
                'c.archived'            => 'No',
                'b.statusArch'          => 'No',
                ($param{empty_domain_is_ok}) ? () : (
                    'b.domain__is_not_null' => 1,
                    'b.domain__ne'          => '',
                ),
            },
            'GROUP BY c.cid, b.domain',
        ];


        $data = get_all_sql( PPC( uid => $chief_uid ), $sql );
    }

    return {text => YAML::Syck::Dump($data)};
}

sub export_error($$) 
{
    my ($code, $text) = @_;

    return {text => $text, code => ($code || 200)};
}

1;
