package Intapi::CurrenciesList;

use Direct::Modern;

use Yandex::HashUtils;

use Currencies;
use JSON;

my @CONSTANT_FOR_EXPORT = grep { uc($_) eq $_ } keys %Currencies::CURRENCY_FIELDS;

=head2 handler

  Возвращает список известных валют и их параметры(код валюты, MIN_PRICE, AUCTION_STEP, MAX_PRICE)
  Принимает именованные параметры:
     - pretty. Задает, надо ли форматировать(pretty-print) Json.
  curl -s 'https://10070.beta3.direct.yandex.ru/CurrenciesList?pretty=1'
  {
   "currencies" : [
      {
         "CURRENCY_CODE" : "YND_FIXED",
         "MIN_PRICE" : 0.01,
         "AUCTION_STEP" : 0.01,
         "MAX_PRICE" : 84
      },
      {
         "AUCTION_STEP" : 0.1,
         "MIN_PRICE" : 0.3,
         "CURRENCY_CODE" : "RUB",
         "MAX_PRICE" : 2500
      }
   ]
  }

=cut

sub handler
{
    my ($r, $multiform) = @_;
    my @filtered_currencies = ();
    for my $currency (get_currencies_list()) {
        push @filtered_currencies, {
                CURRENCY_CODE => $currency,
                map {$_ => get_currency_constant($currency, $_)} @CONSTANT_FOR_EXPORT
            };
    }
    my $coder = JSON->new()->pretty($multiform->{pretty} ? 1 : 0);
    my %result = (
        currencies => \@filtered_currencies,
        fields => hash_cut(\%Currencies::CURRENCY_FIELDS, \@CONSTANT_FOR_EXPORT),
    );
    return {text => $coder->encode(\%result), content_type => "application/json"};
}

1;
