package Intapi::CurrencyRates;

=head1 NAME

    Intapi::CurrencyRates

=cut

use Direct::Modern;

use Settings;

use Currency::Rate ();

=head2 new

=cut

sub new {
    bless {};
}

=head2 get_YND_FIXED_rates

    Возвращает все исторические курсы фишки к известным Директу валютам

    Параметры:
        <нет>

    Результат:
        {
            UAH => {
                       0 => { without_nds => 5, with_nds => 6 },
                20121201 => { without_nds => 6.75, with_nds => 8.1 },
                20140901 => { without_nds => 10, with_nds => 12 },
            },
            ...
        }

    Пример вызова:
        curl -s 'http://8700.beta1.direct.yandex.ru/jsonrpc/CurrencyRates?method=get_YND_FIXED_rates' | json_xs

=cut

sub get_YND_FIXED_rates {
    my ($self, $params) = @_;

    return $Currency::Rate::_CURRENCY_RATE{YND_FIXED};
}

1;
