package Intapi::DirectConfiguration;

# $Id$

=head1 NAME

    Intapi::DirectConfiguration

=head1 DESCRIPTION

    Вывод некоторой информации о текущей конфигурации Директа

    Возможные параметры:
    - keys - какую информацию о конфигурации получать, значения разделяются запятыми.
      Если не указано - выдаётся вся доступная информация.
      Допустимые значения:
        db_info - информация о используемых БД
        direct_version - версия пакета yandex-direct, установленного на сервере
    - slave_info - выдавать ли информацию о состоянии реплики (в db_info)

=cut


use strict;
use warnings;
use Settings;

use JSON;

use Yandex::DBTools;
use Yandex::Shell;

use utf8;

my %CONF_KEYS = (
    db_info => \&_conf_db_info,
    direct_version => \&_conf_direct_version,
    );

=head2 handler

  Точка входа.

=cut
sub handler 
{
    my ($r, $multiform) = @_;

    my @keys = $multiform->{'keys'} ? split(',', $multiform->{'keys'}) : (keys %CONF_KEYS);

    my $ret = {};
    for my $key (grep {$CONF_KEYS{$_}} @keys) {
        $ret->{$key} = $CONF_KEYS{$key}->($multiform);
    };

    return {text => JSON->new()->pretty($multiform->{pretty} ? 1 : 0)->encode($ret), content_type => "text/x-javascript"};
}

# информация о используемых БД
sub _conf_db_info {
    my ($params) = @_;
    my $slave_info = $params->{'slave_info'};

    my $ret = {};

    for my $db (sort grep {!/^unit_tests$/} @{get_db_childs('', recursive => 1)}) {
        my $cfg = get_db_config($db);
        my $db_info = {
            host => $cfg->{host} || '-',
            port => $cfg->{port}  || -1,
        };
        if ($slave_info) {
            $db_info->{slave_info} = eval { get_one_line_sql($db, "SHOW SLAVE STATUS") };
            $db_info->{slave_info_error} = $@ if $@;
        }
        $ret->{$db} = $db_info;
    }
    
    return $ret;
}

# версия Директ, установленного на сервере
sub _conf_direct_version {
    my ($params) = @_;
    my $debian_package = 'yandex-direct';
    my ($version) = 
        map {(split(/\s+/))[2]}
        grep {/^\S+\s+\Q$debian_package\E\s+/}
        split /\n/, yash_qx('dpkg', '-l', $debian_package);
    return $version;
}

1;
