package Intapi::DirectEnv;

=head1 NAME

=head1 DESCRIPTION
    
    Чтение переменных окружения исполняющегося приложения

=cut

use Direct::Modern;
use Settings;
use TextTools qw/smartstrip2/;
use Module::Load;

=head2 new

=cut

sub new {
    bless {};
}

sub get_settings {
    my ($class, $params) = @_;

    my @refind_props;
    for my $pr (grep { $_ } map { smartstrip2($_) } ref $params->{properties} eq 'ARRAY' ? @{$params->{properties}} : ()) {
        my ($module, $variable) = ($pr =~ /^(?:(.+)::)?([^(:)]+)$/);
        push @refind_props, [$module, quotemeta($variable || $pr)];
    }
    my %values;
    {
        no strict 'refs';
        foreach my $p (@refind_props) {
            load $p->[0] if $p->[0];
            $values{join '::', grep { $_ } @$p} = ${ ($p->[0] || 'Settings') . '::' . $p->[1] };
        }
    }
    return \%values;
}

sub get_setting_name {
    my ($class, $params) = @_;
    return $Settings::CONFIGURATION;
}

1;
