package Intapi::ExportCampaigns;
use strict;
use warnings;

# $Id$

=head1 NAME

Intapi::ExportCampaigns

=head1 DESCRIPTION

=head1 SYNOPSIS

=cut

use List::MoreUtils qw(all);
use Readonly;

use CampaignQuery;
use Primitives;
use RBACElementary;
use RBACDirect;
use Settings;

Readonly my %MANAGED_CAMPAIGNS_ROLE_CAN_MANAGE_ALL => map { $_ => 1 } qw( super media placer superreader support );
Readonly my @MANAGED_CAMPAIGNS_FIELDS_OUT          => qw( cid OrderID );

=head1 SUBROUTINES/METHODS

=head2 new

=cut

sub new {
    my ($class) = @_;
    return bless {}, $class;
}

=head2 get_managed_campaigns

https://jira.yandex-team.ru/browse/DIRECT-25820
(Получение прав на кампании для паспортных логинов)

=cut

sub get_managed_campaigns {
    my ( $self, $params ) = @_;

    my $login = $params->{login};

    my $uid = get_uid_by_login2($login);
    die "No such user: $login" unless $uid;

    my $rbac = RBAC2::Extended->get_singleton($uid);

    my $role = rbac_who_is( $rbac, $uid );

    if ( $MANAGED_CAMPAIGNS_ROLE_CAN_MANAGE_ALL{$role} ) {
        return { role_is_supported => 1, has_access_to_all_campaigns => 1 };
    }

    if ( $role ne 'manager' ) {
        return { role_is_supported => 0 };
    }

    my $cids = rbac_get_campaigns_for_edit( $rbac, $uid, $uid );

    my $campaign_data = CampaignQuery->get_campaign_data_multi( { cid => $cids }, [ qw( cid OrderID ) ] );
    return { role_is_supported => 1, has_access_to_all_campaigns => 0, campaign_data => $campaign_data };
}

1;
