package Intapi::FakeAdmin;

# $Id$

=head1 NAME

    Intapi::FakeAdmin

=head1 DESCRIPTION

    Методы fake-админки для тестовых сред

=cut

use strict;
use warnings;

use List::MoreUtils qw/all/;

use Settings;

use APICommon;
use API::ClientOptions;
use FakeAdminTools;
use NotificationTools qw/
    validate_date_interval
    get_emails_by_cids
    get_emails_by_uids
    get_emails_by_logins
    show_mail_logs
    show_sms_logs
    get_java_and_perl_email_templates
    /;

use API::ValidateTools qw/ _check_fields_exist _check_array /;

use Yandex::DBTools;
use Yandex::Shell;
use Yandex::TimeCommon;
use Yandex::DateTime;
use Yandex::Passport ();
use Yandex::TVM2;

use Client;
use Direct::AgencyOptions;
use DirectRedis;
use Primitives;
use PrimitivesIds;
use RBACElementary;
use RBACDirect;
use RedisLock;
use UnitsFactory;
use HashingTools ();
use User ();
use Stat::Const;

use utf8;

sub new
{
    bless {};
}

=head2

wget -qO - 'http://8800.beta1.direct.yandex.ru/secret-jsonrpc/FakeAdmin?method=GetUserShard'
wget -qO - 'http://8800.beta1.direct.yandex.ru/secret-jsonrpc/FakeAdmin?method=GetUserShard&params={"Login":"holodilnikru"}&id=1&json-rpc=2.0'

=cut

=head2 GetUserShard
    Принимает
    {
    'Login' : 'string',
        или
    'ClientID' : 'int'
    }
    Возвращает шард клиента

=cut

sub GetUserShard
{
    my ($self, $params) = @_;

    my $login = $params->{Login};
    my $ClientID = $params->{ClientID};
    die {message => "Отсутствуют Login и ClientId", data => {code => 400}}
        if !defined $login && !defined $ClientID;

    return FakeAdminTools::get_user_shard($login, $ClientID);
}




=head2 FakeRemoveAgencyClientRelation

    Принимет хеш
    {
        'AgencyID' : 'string',
        'ClientID' : 'string',
    }
    
    Запрещает агентству обслуживание клиента

=cut

sub FakeRemoveAgencyClientRelation
{
    my ($self, $params) = @_;

    my $agency_id = $params->{AgencyID}  or die {message => "Отсутствует AgencyId", data => {code => 400}};
    my $client_id = $params->{ClientID}  or die {message => "Отсутствует ClientId", data => {code => 400}};

    my $rbac = RBAC2::Extended->get_singleton(1);
    my $result = rbac_remove_agency_client_relation($rbac, $agency_id, $client_id);    
    die {message => "Запретить обслуживание не удалось", data => {code => 400}}  if $result;

    return 1;
}



=head2 ReshardUser

    Принимет хеш
    {
        'Login' : 'string',
            или
        'ClientID' : 'int',
        'Shard' : 1
    }
    Переносит клиента в другой шард

=cut

sub ReshardUser
{
    my ($self, $params) = @_;

    my $login = $params->{Login};
    my $ClientID = $params->{ClientID};
    
    die {message =>  "Отсутствуют Login и ClientID", data => {code => 400}}
        if !defined $login && !defined $ClientID;
    my $shard = $params->{Shard}
        or die {message =>  "Отсутствует Shard", data => {code => 400}};
    
    my $result = FakeAdminTools::reshard_user($login, $ClientID, $shard);
    
    return $result;
}

=head2 FakeUpdateRetargetingGoals

    На тестовых средах, где скрипт ppcRetargetingCheckGoals.pl
    не запускается, этот метод позволяет обновить, по данным из метрики,
    поле is_accessible в regargeting_goal по заданному ConditionID.

=cut

sub FakeUpdateRetargetingGoals
{
    my ($self, $params) = @_;

    my $condition_id = $params->{ConditionID}
        or die {message => "Отсутствует ConditionID", data => {code => 400}};
        
    return FakeAdminTools::update_retargeting_goals($condition_id);

}

=head2 FakeClientParams

    На тестовых средах обновляет параметры клиента

=cut

sub FakeClientParams
{
    my ($self, $params) = @_;
    
    my $login = $params->{login};
    die {message => "Нужно передать логин", data => {code => 400}} unless $login;

    return FakeAdminTools::save_client_params($login, $params);
}

=head2 FakeGetClientParams

    На тестовых средах выводит параметры клиента

=cut

sub FakeGetClientParams
{
    my ($self, $params) = @_;
    
    my $login = $params->{login};
    die {message => "Нужно передать логин", data => {code => 400}} unless $login;

    return FakeAdminTools::get_client_params($login, $params->{fields});
}


=head2 FakeCampaignParams

    На тестовых средах обновляет параметры кампании

=cut

sub FakeCampaignParams
{
    my ($self, $params) = @_;
    
    my $cid = $params->{cid};
    die {message => "Нужно передать cid кампании", data => {code => 400}} unless $cid;

    return FakeAdminTools::save_camp_data($cid, {only_specified => 1}, %$params);
}

=head2 FakeGetCampaignParams

    На тестовых средах возвращает параметры кампании

=cut

sub FakeGetCampaignParams
{
    my ($self, $params) = @_;
    
    my $cid = $params->{cid};
    die {message => "Нужно передать cid кампании", data => {code => 400}} unless $cid;

    return FakeAdminTools::get_camp_data($cid);
}

=head2 FakeBalanceNotification 

    На тестовых средах эмулирует нотификацию от Баланса о изменении денег на счете

=cut

sub FakeBalanceNotification
{
    my ($self, $params) = @_;
    
    my $cid = $params->{cid};
    die {message => "Нужно передать cid кампании", data => {code => 400}} unless $cid;

    return FakeAdminTools::balance_notification($cid, %$params);
}

=head2 FakeGroupParams

    На тестовых средах обновляет параметры группы

=cut

sub FakeGroupParams
{
    my ($self, $params) = @_;
    
    my $pid = $params->{pid};
    die {message => "Нужен pid группы", data => {code => 400}} unless $pid;

    return FakeAdminTools::save_group_data($pid, {only_specified => 1}, %$params);
}

=head2 FakeGetGroupParams

    На тестовых средах возвращает параметры группы

=cut

sub FakeGetGroupParams($$)
{
    my ($self, $params) = @_;
    
    my $pid = $params->{pid};
    die {message => "Нужен pid группы", data => {code => 400}} unless $pid;

    return FakeAdminTools::get_group_data($pid);
}

=head2 FakeBannerParams

    На тестовых средах обновляет параметры объявления

=cut

sub FakeBannerParams
{
    my ($self, $params) = @_;
    
    my $bid = $params->{bid};
    die {message => "Нужен bid баннера", data => {code => 400}} unless $bid;

    return FakeAdminTools::save_banner_data($bid, {only_specified => 1}, %$params);
}

=head2 FakeGetBannerParams

    На тестовых средах возвращает параметры объявления

=cut

sub FakeGetBannerParams($$)
{
    my ($self, $params) = @_;
    
    my $bid = $params->{bid};
    die {message => "Нужен bid баннера", data => {code => 400}} unless $bid;

    return FakeAdminTools::get_banner_data($bid);
}

=head2 FakeGetBannerPhrasesParams

    На тестовых средах возвращает параметры всех фраз объявления

=cut

sub FakeGetPhrasesParams($$)
{
    my ($self, $params) = @_;
    
    my ($id, $id_type);
    if (ref $params eq 'HASH') {
        $id_type = [keys %$params]->[0];
        $id = $params->{$id_type}
    } else {
        $id = $params;
    }
    die {message => "Нужен id фразы", data => {code => 400}} unless $id;
    
    return FakeAdminTools::get_phrases_data($id, $id_type);
}

=head2 FakeBannerPhrasesParams

    На тестовых средах обновляет параметры всех фраз объявления

=cut

sub FakePhrasesParams($$)
{
    my ($self, $params) = @_;

    return FakeAdminTools::save_phrases_data($params);
}

sub FakeConvertCurrencyClient2
{
    my ($self, $params) = @_;

    my $clientid = get_one_field_sql(PPC, ["select ClientID from users", where => { login => $params->{Login} }]);

    if ($params->{ForceConvert}) {
        do_sql(PPC, ["update currency_convert_queue set start_convert_at = NOW()", where => { "ClientID" => $clientid, "state__ne" => "Done" }]);
    }
    yash_system("$Settings::ROOT/protected/ppcCurrencyConvertMaster.pl", "--once", "--clientid", $clientid);
    
    return 1;
}

sub FakeConvertCurrencyClient
{
    my ($self, $params) = @_;
    
    my $login = $params->{Login} || die {message => "Нужен логин", data => {code => 400}};
    my $uid = get_uid_by_login($login);
    my $clientid = get_clientid(login => $login);
    
    my $rbac = RBAC2::Extended->get_singleton(1);
    my $client_chief_uid = rbac_get_chief_rep_of_client_rep($uid);

    my $convert_type = $params->{ConvertType}
        || die {message => "Not specified ConvertType = (COPY|MODIFY)", data => {code => 400}};

    if ($params->{AddConvertCurrencyQueue}) {

        my $currency = $params->{TargetCurrency}
            || die {message => "Not specified TargetCurrency", data => {code => 400}};

        my %CURRENCY_TO_COUNTRY = (
            'RUB' => 225, # Россия
            'UAH' => 187, # Украина
            'KZT' => 159, # Казахстан
            'TRY' => 983, # Турция
        );

        # ставим заявку на переход в очередь
        do_insert_into_table(PPC(ClientID => $clientid), 'currency_convert_queue', {
            ClientID => $clientid,
            uid => $client_chief_uid,
            convert_type => $convert_type,
            new_currency => $currency,
            country_region_id => $CURRENCY_TO_COUNTRY{$currency} || 225,
            email => "direct-dev-letters\@yandex-team.ru",
            start_convert_at => unix2mysql(time() + 60),
        }, ignore => 1);

        # записываем дату перехода
        do_replace_into_table(PPC(ClientID => $clientid), 'client_currency_changes', {
            ClientID => $clientid,
            currency_from => 'YND_FIXED',
            currency_to => $currency,
            date => unix2mysql(time() + 60),
        });

        do_insert_into_table(PPC(ClientID => $clientid), 'clients_to_force_multicurrency_teaser', {
            ClientID => $clientid,
            modify_convert_allowed => ($convert_type eq 'MODIFY') ? 1 : 0,
        }, on_duplicate_key_update => 1, key => 'ClientID');
    }

    if ($params->{ForceConvert}) {
        do_sql(PPC(ClientID => $clientid), ["update currency_convert_queue set start_convert_at = NOW() + INTERVAL 1 MINUTE", where => { "ClientID" => $clientid, "state__ne" => "Done" }]);
    } elsif ($params->{DelayConvert}) {
        do_sql(PPC(ClientID => $clientid), ["update currency_convert_queue set start_convert_at = NOW() + INTERVAL $params->{DelayConvert} MINUTE", where => { "ClientID" => $clientid, "state__ne" => "Done" }]);
        return 1;
    }

    if ($convert_type eq 'COPY') {
        # останавливаем кампании, чтобы не дожидаться появления statusActive, которое на бетах никогда не случится из-за отстутствия экспорта в БК
        do_update_table(PPC(ClientID => $clientid), "campaigns", {statusActive => "No", statusShow => "No"}, where => { uid => $client_chief_uid });
    }

    my $converted = FakeAdminTools::convert_client_currency($clientid) ? 1 : 0;

    if ($params->{SetNDS}) {
        do_sql(PPC(ClientID => $clientid), "INSERT INTO client_nds SET nds = ?, ClientID = ?, date_from = NOW(), date_to = ? ON DUPLICATE KEY UPDATE nds=values(nds)", $params->{SetNDS}, $clientid, $Settings::END_OF_TIME);
    }
    
    return $converted;
}

=head2 

curl -s -d '{"method":"FakeBalanceNotificationNDS","params":[{"Login":"senjor", "VATRate": 13, "date_from": "2014-01-01", "date_to": "2014-04-01" }]}' 'http://8880.beta1.direct.yandex.ru/secret-jsonrpc/FakeAdmin'

=cut
sub FakeBalanceNotificationNDS
{
    my ($self, $params) = @_;

    my @request = map {[
            get_clientid(login =>$_->{Login})
            , $_->{VATRate}
            , $_->{date_from} || $BEGIN_OF_TIME_FOR_STAT,
            , $_->{date_to} || $Settings::END_OF_TIME,
        ]
    } @$params;
    
    return FakeAdminTools::fake_balance_notification_nds(@request);
}


=head2 FakeSetAllowBudgetAccountForAgency($self, $params)

    Выставление признака агентства - создавать ли клиента по умолчанию с ОС
    $params = {
        Login => 'логин агентства',
        YesNo => 'Yes/No',
    }

    если $params->{YesNo} eq 'No', по умолчанию клиенты будут создаваться без ОС, и наоборот

=cut
sub FakeSetAllowBudgetAccountForAgency
{
    my ($self, $params) = @_;

    my $login = $params->{Login}
        or die {message => "Отсутствует Login", data => {code => 400}};

    my $yesno = $params->{YesNo}
        or die {message => "Отсутствует YesNo", data => {code => 400}};

    unless ($yesno =~ /^(Yes|No)$/ ) {
        die {message => "Параметр YesNo должен содержать либо 'yes' либо 'no'", data => {code => 400}};
    }

    my $default_with_wallet = $yesno eq 'Yes' ? 1 : 0;
    $login =~ s/\./-/g;
    my $agency_id = get_clientid(login => $login);

    die {message => "Отсутствует агентство $login", data => {code => 400}} if !defined $agency_id;

    my $agency_options = Direct::AgencyOptions->get_item($agency_id);

    die {message => "Отсутствует агентство $login", data => {code => 400}} if !defined $agency_options;

    $agency_options->default_clients_with_wallet($default_with_wallet);
    # если хотим, чтобы агентство по умолчанию создавало клиентов без ОС, даем ему такое право
    if (!$default_with_wallet) {
        $agency_options->allow_clients_without_wallet(1);
    }
    Direct::AgencyOptions->new([$agency_options])->update();

    return 1;
}


=head2 AddEvents

    Тестовый метод для генерации лога событий. Доступен только супер пользователям на тестовых средах
    На вход получает массив, аналогичный ответу GetEventsLog, ответ - 1, или ошибка

=cut

sub AddEvents {
    my ($self, $params) = @_;
    my $cids = [map {$_->{CampaignID} || $_->{AccountID}} @$params];
    my $cid2clientid = get_cid2clientid(cid => $cids);
    
    my @events_to_insert;
    
    my %token2eventtype = reverse(%APICommon::EVENT_TYPE2TOKEN);
    my %token2eventattr = reverse(%APICommon::EVENT_ATTR2TOKEN);
    my %token2modres = reverse(%APICommon::EVENT_MODRES2TOKEN);

    foreach my $event (@$params) {
        
       my $eventtype = $token2eventtype{$event->{EventType}};

        my $event_descr = $EventLog::EVENTS{$eventtype};

        my %event_to_insert = (
            slug => $eventtype,
            ClientID => $cid2clientid->{$event->{CampaignID} || $event->{AccountID}},
            cid => $event->{CampaignID} || $event->{AccountID},
        );

        if ($event_descr->{object} eq 'banner') {
            $event_to_insert{bid} = $event->{BannerID};
        }

        if ($event_descr->{object} eq 'phrase') {
            $event_to_insert{bid} = $event->{BannerID};
            $event_to_insert{bids_id} = $event->{PhraseID};
        }

        my $event_params = undef;
        foreach my $attr (keys %{$event->{Attributes}}) {
            my %allowed_attributes = map {$_ => 1} @{$event_descr->{params}};
            my $inner_attr_name = $token2eventattr{$attr};
            if ($inner_attr_name) {
                if (
                    ($inner_attr_name eq 'sum_rest'
                        || $inner_attr_name eq 'sum_payed'
                        || $inner_attr_name eq 'finish_date'
                        || $inner_attr_name eq 'old_place'
                        || $inner_attr_name eq 'new_cpm_limit'
                    )
                     && $allowed_attributes{$inner_attr_name}
                )
                {
                    $event_params->{$inner_attr_name} = $event->{Attributes}{$attr};
                }
                if ($inner_attr_name eq 'bs_stop_time'
                    && $allowed_attributes{$inner_attr_name}
                ) {
                    $event_params->{$inner_attr_name} = iso8601_2_mysql($event->{Attributes}{$attr});
                }
                if ($inner_attr_name eq 'is_edited_by_moderator'
                    && $allowed_attributes{$inner_attr_name}
                ) {
                    $event_params->{$inner_attr_name} = $event->{Attributes}{$attr} && $event->{Attributes}{$attr} eq 'Yes' ? 1 : 0;
                }
                if ($allowed_attributes{currency}) {
                    $event_params->{currency} = $event->{Attributes}{Currency} || "YND_FIXED";
                }
                if ($allowed_attributes{new_cpm_limit_currency}) {
                    $event_params->{new_cpm_limit_currency} = $event->{Attributes}{Currency} || "YND_FIXED";
                }
                if ($event_descr->{type} == 8 && $event->{Attributes}{ModerationResult}) {
                    $event_params->{results} = {
                        global => $token2modres{$event->{Attributes}{ModerationResult}},
                        text => "Yes",
                        phrases => "Yes",
                    };
                }
            }
        }
        $event_to_insert{params} = $event_params;

        push @events_to_insert, \%event_to_insert;
    }
    if (scalar @events_to_insert) {
        eval {
            EventLog::log_several_events(\@events_to_insert);
        };

        if ($@) {
            die {message => $@ =~ m/(.*)at\s\//, data => {code => 400}};
        }
    }

    return 1;
}

=head2 SetDiscount

    Тестовый метод для принудительной установки скидки клиенту через график скидок.
    На вход получает ссылку на хеш вида ClientID => discount. 
    discount: 
      либо скидка (в процентах), 
      либо массив хешей вида {"discount":"13", "date_from": "2014-01-01", "date_to": "2014-04-01"}

    curl -s -d '{"method":"SetDiscount","params":{"1575300":"13"}}' 'http://beta2.direct.yandex.ru:9705/secret-jsonrpc/FakeAdmin'

    curl -s -d '{"method":"SetDiscount","params":{"79":[{"discount":"13", "date_from": "2014-01-01", "date_to": "2014-04-01"}, {"discount":"23", "date_from": "2015-01-01", "date_to": "2015-04-01"}]}}' 'http://8880.beta1.direct.yandex.ru/secret-jsonrpc/FakeAdmin'

=cut

sub SetDiscount {
    my ($self, $params) = @_;

    FakeAdminTools::update_clients_discount($params);
}

=head2 FakeClientUnitsBalance

    Тестовый метод для определения доступного для расходования количества баллов в рамках скользящего окна
    Не учитыает проставленные вручную, например из интерфейса, баллы на uid

=cut

sub FakeClientUnitsBalance {
    my ( $self, $params ) = @_;

    my $err = _check_fields_exist( $params, [qw/ client_id /], def => 1, type => 'unsignedint' );
    die { message => $err, data => { code => 400 } } if $err;

    my $client_id = $params->{client_id};

    my $units = UnitsFactory::create($client_id, $self->_get_client_api5_units_daily($client_id), $params->{basket_name});

    return $units->balance;
}

sub _get_client_api5_units_daily {
    my ($self, $client_id) = @_;
    my $api_client_opts = API::ClientOptions::get($client_id, [qw/api5_units_daily/]);
    return $api_client_opts->{api5_units_daily};
}

=head2 FakeWithdrawClientUnits

    Тестовый метод расходования определенного количества баллов определенным клиентом в указанном интервале

=cut

sub FakeWithdrawClientUnits {
    my ( $self, $params ) = @_;

    my $err = _check_fields_exist( $params, [qw/ client_id amount /], def => 1, type => 'unsignedint' );
    die { message => $err, data => { code => 400 } } if $err;

    my $units = UnitsFactory::create($params->{client_id}, undef, $params->{basket_name});

    return $units->withdraw( $params->{amount} );
}

=head2 FakeClearClientSpentUnits

    Тестовый метод для обнуления израсходованных клиентом баллов

=cut

sub FakeClearClientSpentUnits {
    my ( $self, $params ) = @_;

    my $err = _check_fields_exist( $params, [qw/ client_id /], def => 1, type => 'unsignedint' );
    die { message => $err, data => { code => 400 } } if $err;

    my $units = UnitsFactory::create($params->{client_id}, undef, $params->{basket_name});

    return $units->_restore_balance();
}

=head2 FakeCreateDynamicAdgroup

    Создать группу с динамическими баннерами.
    Принимает ссылку на хеш вида:
    {
        cid => ..., # номер кампании, в которую нужно добавить группу
        uid => ..., # uid владельца кампании
        domain => ...,  # домен, который будут рекламировать динамические объявления
        geo => ..., # строка с геотаргетингом (опционально)
        dynamic => [    # массив данных, которые будут записаны в bids_dynamic ("фразы со ставками")
            {
                condition => [{}, {}, {}],  # условие нацеливания (массив целей), описание формата смотри
                    # в коде FakeAdminTools::create_dynamic_adgroup или на вики
                    # https://beta.wiki.yandex-team.ru/Direkt/technicaldesign/DynamicBanners/#predpolagaemajasxemapredstavlenija
                price => ...,               # ставка на поиске (никак не валидируется, если не указано - 1.5)
                price_context => ...,       # ставка на сети (никак не валидируется, по умолчанию - 1.6)
            }, ...
        ],
        banner_bodies => [ # массив текстов баннеров. Будет создано по одному баннеру на каждый
            'body1',
            'body2',
            ...
        ],
        p_statusModerate => ...,    # 'Yes/No/Sent/Sending/Ready/New', по умолчанию Yes
        p_statusPostModerate => ...,# 'New/Yes/No/Ready/Sent/Rejected', по умолчанию Yes
        b_statusModerate => ...,    # 'Yes/No/Sent/Sending/Ready/New', по умолчанию Yes
        b_statusPostModerate => ...,# 'New/Yes/No/Ready/Sent/Rejected', по умолчанию Yes
    }

=cut
sub FakeCreateDynamicAdgroup {
    my ($self, $params) = @_;

    if (ref $params->{dynamic} ne 'ARRAY') {
        $params->{dynamic} = [$params->{dynamic}];
    }
    if (ref $params->{banner_bodies} ne 'ARRAY') {
        $params->{banner_bodies} = [$params->{banner_bodies}];
    }

    return FakeAdminTools::create_dynamic_adgroup(%$params);
}

=head2 ShowMailLogs

    Тестовый метод для получения информации об отправленных письмах из лога.

=cut

sub ShowMailLogs($$) {
    my ( $self, $params ) = @_;

    my ( $date_from, $date_to );
    eval {
        ( $date_from, $date_to ) = validate_date_interval( date_from => $params->{date_from}, date_to => $params->{date_to}, limit_days => 1000 );
    };
    die { message => $@, data => { code => 400 } } if $@;

    my %args = (
        date_from => $date_from,
        date_to   => $date_to,
    );

    my @emails;

    if ( defined $params->{cids} ) {
        if ( _check_array( $params->{cids}, 'cids', not_empty => 1, type => 'unsignedint' ) ) {
            die { message => "Не корректно задан массив cids", data => { code => 400 } } if $@;
        }
        push @emails, @{ get_emails_by_cids( $params->{cids} ) };
    }

    if ( defined $params->{uids} ) {
        if ( _check_array( $params->{uids}, 'uids', not_empty => 1, type => 'unsignedint' ) ) {
            die { message => "Не корректно задан массив uids", data => { code => 400 } } if $@;
        }
        push @emails, @{ get_emails_by_uids( $params->{uids} ) };
    }

    if ( defined $params->{logins} ) {
        if ( _check_array( $params->{logins}, 'logins', not_empty => 1, type => 'string' ) ) {
            die { message => "Не корректно задан массив logins", data => { code => 400 } } if $@;
        }
        push @emails, @{ get_emails_by_logins( $params->{logins} ) };
    }

    if ( defined $params->{emails} ) {
        if ( _check_array( $params->{emails}, 'emails', not_empty => 1, type => 'string' ) ) {
            die { message => "Не корректно задан массив logins", data => { code => 400 } };
        }
        push @emails, @{ $params->{emails} };
    }

    $args{emails} = \@emails if @emails;

    if ( defined $params->{template_names} ) {
        if ( _check_array( $params->{template_names}, 'template_names', not_empty => 1, type => 'string' ) ) {
            die { message => "Не корректно задан массив template_names", data => { code => 400 } };
        }

        # В "ru" пристутствуют все возможные виды шаблонов, поэтому просмотр только ru будет достаточен.
        # так же пользователю не нужны подшаблоны, т.е. шаблоны имя которых начинается с i_
        my $exist_templates = get_java_and_perl_email_templates("ru");

        my @templates = grep { defined( $_ ) && exists( $exist_templates->{ $_ } ) } @{ $params->{template_names} };

        $args{template_names} = \@templates if @templates;
    }
    # Первоначально логи писем писались в ppclog синхронно, поэтому запрос в ShowMailLogs сразу после выполнения кода, который пишет письма, гарантированно отдавал нужное письмо.
    # Теперь письма читаются из clickhouse, куда они доставляются через push-client/logbroker, поэтому для тестов отправки писем приходится выхидать какое-то время, пока они там появятся.
    # Логично ожидание перенести в тесты, но пока непонятно, насколько хорошо такая схема будет работать, делаем подешевле.
    sleep(60);

    return show_mail_logs( \%args );
}

=head2 ShowSmsLogs

    Тестовый метод для получения информации об отправленных смс из очереди на отправку.

=cut

sub ShowSmsLogs($$) {
    my ( $self, $params ) = @_;

    my ( $date_from, $date_to );
    eval {
        ( $date_from, $date_to ) = validate_date_interval( date_from => $params->{date_from}, date_to => $params->{date_to}, limit_days => 1000 );
    };
    die { message => $@, data => { code => 400 } } if $@;

    my %args = (
        by_add_time => 1,
        date_from   => $date_from,
        date_to     => $date_to,
    );

    my @uids;

    if ( defined $params->{uids} ) {
        if ( _check_array( $params->{uids}, 'uids', not_empty => 1, type => 'unsignedint' ) ) {
            die "Не корректно задан массив uids\n";
        }
        push @uids, @{ $params->{uids} };
    }

    if ( defined $params->{logins} ) {
        if ( _check_array( $params->{logins}, 'logins', not_empty => 1, type => 'string' ) ) {
            die "Не корректно задан массив logins\n";
        }
        push @uids, @{ get_uids(login => $params->{logins}) };
    }

    $args{uids} = \@uids if @uids;
    
    if ( defined $params->{cids} ) {
        if ( _check_array( $params->{cids}, 'cids', not_empty => 1, type => 'unsignedint' ) ) {
            die "Не корректно задан массив cids\n";
        }

        $args{cids} = $params->{cids};
    }

    my $results;
    eval {
        $results = show_sms_logs( \%args );
    };
    die { message => $@, data => { code => 400 } } if $@;

    return $results;
}

=head2 FakeCreateClient

    Создаёт самостоятельного клиента в произвольной валюте

    Принимает параметры:
        Login
        Name
        Password
        Surname
        Currency

    Возвращает ClientID созданного клиента

=cut

sub FakeCreateClient {
    my ( $self, $params ) = @_;

    my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
    my $ip = $ENV{REMOTE_ADDR};
    my $password = $params->{Password} || HashingTools::get_random_string(length=> 8, alphabets=>'wWd');
    my $new_login_data = Yandex::Passport::create_passport_login($params->{Login}, $params->{Name}, $params->{Surname}, $password, ip => $ip, tvm_ticket => $ticket);
    die 'error creating passport login' unless $new_login_data && ref($new_login_data) eq 'HASH' && $new_login_data->{status} eq 'ok';
    my $client_uid = $new_login_data->{uid};

    my $email = "$params->{Login}\@yandex.ru";
    my $operator_uid = 1;
    my $currency = $params->{Currency} || 'YND_FIXED';

    my $new_client = {
        agency => 'no',
        client_uid  => $client_uid,
        email => $email,
        name => $params->{Name},
        currency => $currency,
    };
    if ( create_client_id($new_client, $operator_uid) ) {
        die "error creating client for uid = $client_uid";
    }
    my $client_id = $new_client->{new_clientID};

    my $CREATE_UPDATE_USER_OBJECT = {
        login => $params->{Login},
        email => $email,
        UID => $client_uid,
        initial_currency => $currency,
        ClientID => $client_id,
    };
    User::create_update_user( $client_uid, $CREATE_UPDATE_USER_OBJECT );

    API::ClientOptions::add($client_id, {'api_enabled' => 'Default'});

    return $client_id;
}

=head2 TakeRedisLock

    curl -s -d '{"method":"TakeRedisLock","params":{"key":"hello-world", "ttl": 1}}' 'http://11011.beta4.direct.yandex.ru/secret-jsonrpc/FakeAdmin' | jq .

=cut
sub TakeRedisLock {
    my ($self, $params) = @_;

    my $redis = DirectRedis::get_redis();
    my $key = $params->{key};
    my $ttl = $params->{ttl};

    my ($locks, $failed) = RedisLock::lock_multi($redis, [$key], $ttl);
    return {
        locks => $locks,
        failed => $failed,
    };
}

=head2 DropRedisLock

    curl -s -d '{"method":"DropRedisLock","params":{"locks":{"hello-world":1231231231}}}' 'http://11011.beta4.direct.yandex.ru/secret-jsonrpc/FakeAdmin' | jq .

=cut
sub DropRedisLock {
    my ($self, $params) = @_;

    my $redis = DirectRedis::get_redis();

    my ($unlocked, $failed) = RedisLock::unlock_multi($redis, $params->{locks});
    return {
        unlocked    => $unlocked,
        failed      => $failed,
    };
}

=head2 SendCampaignToBalance

    Переотправить кампанию в баланс

=cut

sub SendCampaignToBalance {
    my ($self, $params) = @_;
    
    my $cid = $params->{cid};
    die {message => "Нужно передать cid кампании", data => {code => 400}} unless $cid;

    return FakeAdminTools::send_campaign_to_balance($cid);
}

1;
