package Intapi::FileStorage;

use strict;
use warnings;

=head1 NAME

    intapi/file-storage

=head1 DESCRIPTION

    Модуль предоставляет интерфейс для доступа к хранилищу файлов через http
    Нужно как временный хак, т.к сейчас хранилище это база в директе.

    Как только она станет отдельным сервисом этот модуль станет depricated

=cut

use Direct::Storage;
use Direct::Storage::Types;
use Settings;
use Yandex::I18n;
use HttpTools;
use MIME::Base64;

use utf8;
    
my %storage_map = (
    # FileStorage => Direct::Storage
    documents => 'mod_licenses',
);

=head2 get_doc

Получить файл
Параметры именованные:
    id - имя файла
    type - тип файла из Direct::Storage::Types
    owner - user id
    client_id - ClientID

Возвращает хеш
 { data => $file_data_in_base64 }

=cut

sub get_doc
{
    my ( %FORM ) = (@_);

    my $doc_id = $FORM{id};
    my $type = $FORM{type};
    my $uid = $FORM{owner};
    my $client_id = $FORM{client_id};

    return {code => 520, text => iget('Не указан параметр %s', 'id')}  unless $doc_id;

    return { code => 520, text => iget('Не указан параметр %s', 'uid') } unless $uid || $client_id;

    my $storage = Direct::Storage->new();
    my $mds_type = $storage_map{$type} // $type;
    my $file = $storage->get_file($mds_type,
        filename => $doc_id,
        ( Direct::Storage::Types::mds_check_type_trait($mds_type, 'empty_client_id') ? () : ( uid => $uid, ClientID => $client_id ) ),
    );
    
    unless ($file) {
        return { code => 424, text => iget('Файл не найден') };
    }

    my $content = $file->content;
    return { data => encode_base64(Encode::is_utf8($content) ? Encode::encode_utf8($content) : $content ) };
}

=head2 put_doc

Сохранить файл
Параметры именованные:
    type - тип файла из Direct::Storage::Types
    content - содержимое файла в base64
    owner - uid (user id)

Возвращает хеш:
{ text => $path_to_new_file }

=cut

sub put_doc
{
    my ( %FORM ) = @_;
    # use Data::Dumper; warn Dumper( \%FORM );
    my $type = $FORM{type};

    my $content;
    $content = decode_base64( $FORM{content} ) if $FORM{content};

    if ( !$FORM{content} || length($content) > $Settings::MAX_ATTACHED_DOCUMENT_SIZE ) {
        return {code => 520, text => iget('Нет содержимого файла или оно слишком большое') };
    }

    my $storage = Direct::Storage->new();
    my $mds_type = $storage_map{$type} // $type;
    my $file = eval { $storage->save($mds_type, $content,
        ( Direct::Storage::Types::mds_check_type_trait($mds_type, 'empty_client_id') ? () : ( uid => $FORM{owner} ) ),
        ( Direct::Storage::Types::mds_check_type_trait($mds_type, 'custom_name') ? ( filename => $FORM{filename} ) : () ),
    ) };
    if ($@) {
        warn $@;
        return { code => 520, text => iget('Ошибка сохранения файла') };
    }

    return { text => $file->filename };
}

=head2 remove_doc

Удалить файл
Параметры именованные:
    type - тип файла из Direct::Storage::Types
    id - имя файла
    owner - uid, user id

Возвращает хеш
{ text => '' }

=cut

sub remove_doc
{
    my ( %FORM ) = @_;
    my $type = $FORM{type};

    my $doc_id = $FORM{id};

    return {code => 520, text => iget('Не указан параметр %s', 'id') } unless $doc_id;

    return { code => 520, text => iget('Не указан параметр %s', 'uid') } unless $FORM{owner};
    my $storage = Direct::Storage->new();
    my $mds_type = $storage_map{$type} // $type;
    eval { $storage->delete_file($mds_type,
        filename => $FORM{filename}
        ( Direct::Storage::Types::mds_check_type_trait($mds_type, 'empty_client_id') ? () : ( uid => $FORM{owner} ) ),
    ) };

    return {text => ''};
}

sub handler
{
    my ($r, $multiform) = @_;

    my $form = multiform2directform($multiform);
    my %FORM = %$form;
    # use Data::Dumper; warn Dumper( \%FORM );

    unless ( $FORM{action} ) {
        return {text => iget('Не указано имя команды'), code => 520};
    }
    unless ( $FORM{type} ) {
        return { code => 520, text => iget("Не указан тип файла") }
    }

    #unless ( $FORM{type} ) {
    #    return { code => 520, text => iget("Не указан тип файла") }
    #}

    if ( $FORM{action} eq 'get_file' ) {
        return get_doc( %FORM );
    } elsif ( $FORM{action} eq 'put_file' ) {
        return put_doc( %FORM );
    } elsif ( $FORM{action} eq 'remove_file' ) {
        return remove_doc( %FORM );
    } else {
        return {text => iget('Неизвестная команда'), code => 520};
    }
}

1;
