package Intapi::JavaExport::GeoRegions;
use strict;
use warnings;

use Yandex::HashUtils qw/hash_cut/;

use geo_regions;
use JSON;
use utf8;



=head2 handler

  Возвращает список регионов из geo_regions для использования из java
  Принимает именованные параметры:
     - type (global|russian|api). Какое дерево регионов надо извлекать.
     - pretty. Задает, надо ли форматировать(pretty-print) Json.
  curl -s 'https://10070.beta3.direct.yandex.ru/JavaExportGeoRegions?pretty=1'

=cut
sub handler
{
    my ($r, $multiform) = @_;

    my $tree_type = $multiform->{type} // 'global';
    my $tree;
    if ($tree_type eq 'global') {
        $tree = \%geo_regions::GEOREG;
    } elsif ($tree_type eq 'russian') {
        $tree = \%geo_regions::GEOREG_FOR_RU;
    } elsif ($tree_type eq 'api') {
        $tree = \%geo_regions::GEOREG_API;
    } else {
        return {text => "Invalid tree type $tree_type", code => 400};
    }

    my @regs;
    for my $reg (sort { $a <=> $b } keys %$tree) {
        my $data = $tree->{$reg};
        my $export = hash_cut $data, qw/name ua_name tr_name ename type geo_flag/;
        $export->{id} = $reg;
        $export->{parent} = $data->{parents}->[-1];
        push @regs, $export;
    }

    my $coder = JSON->new()
        ->pretty($multiform->{pretty} ? 1 : 0)
        ->canonical(1);

    my %result = (
        geo_regions => \@regs,
        metro_stations => \%geo_regions::METRO
    );

    return {text => $coder->encode(\%result), content_type => "text/x-javascript"};
}

1;
