package Intapi::Mirrors;

=head1 NAME

    Intapi::Mirrors

=head1 DESCRIPTION

    JSON-RPC интерфейс для получения фильтр-домена по домену

=cut

use warnings;
use strict;
use utf8;

use BS::Export ();
use MirrorsTools;

use Yandex::IDN ();

my $mirrors;

=head2 new

    Конструктор

=cut
sub new {
    $mirrors //= MirrorsTools->new(use_db => 1, dont_load_file => 1);
    bless {};
}

=head2 get_domain_filter

    Получить фильтр-домен. (похож на старую SOAP-ручку /mirrors, но умеет сразу массив доменов)
    Параметры:
        массив строк с доменами для определения фильтр-доменов
    Результат:
        массив строк с вычисленными фильтр-доменами или null'ами (для невалидных доменов из запроса)
            результаты представлены в том же порядке, что исходные домены из запроса

=cut
sub get_domain_filter {
    my ($self, $params, $procedure, @extra_args) = @_;
    my @result;

    if (ref $params ne 'ARRAY') {
        die 'params should be an array';
    }

    for my $domain (@$params) {
        if ($domain) {
            push @result, $mirrors->domain_filter($domain);
        } else {
            # пустые сразу пропускаем
            push @result, undef;
        }
    }

    return \@result;
}

=head2 get_domain_filter_for_bs

    Получить фильтр-домен для БК (как в экспорте).
    Параметры:
        массив строк с доменами для определения фильтр-доменов
    Результат:
        массив строк с вычисленными фильтр-доменами или null'ами (для невалидных доменов из запроса)
            результаты представлены в том же порядке, что исходные домены из запроса

=cut
sub get_domain_filter_for_bs {
    my ($self, $params, $procedure, @extra_args) = @_;
    my @result;

    if (ref $params ne 'ARRAY') {
        die 'params should be an array';
    }

    for my $domain (@$params) {
        if ($domain && Yandex::IDN::is_valid_domain($domain)) {
            # при перекодировании в punycode невалидных доменов получается пустая строка - заменяем на undef
            my $result = BS::Export::get_domain_filter($domain) || undef;
            push @result, $result;
        } else {
            # пустые и кривые сразу пропускаем
            push @result, undef;
        }
    }

    return \@result;
}
1;
