package Intapi::PayForAll;

use Yandex::HashUtils qw/hash_copy hash_merge hash_map/;

=head1 NAME

    Intapi::PayForAll

=head1 DESCRIPTION

=cut

use Direct::Modern;

use MoneyTransfer;

use PrimitivesIds;
use RBACElementary;
use RBACDirect;

use Yandex::DBTools;
use Settings;
use DoCmd;

use User qw/get_user_data get_users_data/;
use Client qw/get_client_currencies get_client_data/;
use Yandex::SendMail qw/send_alert/;
use Direct::ResponseHelper qw(respond_to respond_template error redirect respond_json);
use URI::Escape qw/uri_escape_utf8/;
use Promocodes qw/is_promocode_entry_available get_promocode_domains/;
use MailNotification qw/mail_notification/;
use Yandex::I18n qw/iget/;
use Yandex::Balance qw/balance_create_request/;

=head2 handler

    Валидация оплаты кампании

    Параметры:
        uid - клиент
        UID - оператор
        cid - кампания для платы
        sum - сумма с НДС для оплаты

=cut

sub handler {
    my ($r) = @_;

    my $req_params = JSON::from_json($r->content, {utf8 => 1});

    my $uid = $req_params->{uid};
    my $userID = $req_params->{UID};
    my $cid = $req_params->{cid};
    my $sum = $req_params->{sum};
    my $role = $req_params->{role};
    my $requestUrl = $req_params->{requestUrl};
    my $login = $req_params->{login};
    my $with_nds = $req_params->{with_nds};
    my $lang_from_request = $req_params->{lang};

    my $login_rights = {
        super_control => (($role eq 'super') ? 1 : 0),
        is_any_client => (($role eq 'client') ? 1 : 0)
    };

    my $requestURI = URI->new($requestUrl);
    my $request_domain = $requestURI->host || 'direct.yandex.ru';
    my $request_scheme = $requestURI->scheme;
    my $tld_domain = $request_domain =~ /(ru|ua|com|tr|by)$/ ? $1 : 'ru';
    my $return_path = "https://$request_domain?cmd=showCamps" . ($login ? "&ulogin=" . uri_escape_utf8($login) : "");

    my $rbac = RBAC2::Extended->get_singleton(1);

    my $client_id = get_clientid(uid => $uid);
    my $chief_uid = rbac_get_chief_rep_of_client($client_id);
    my $client_chief_uid = $chief_uid;

    my $params = {
        sums => {
            $cid => $sum
        },
        client_chief_uid => $client_chief_uid,
        sums_with_nds    => (($with_nds) ? 1 : 0),
        custom_min_pay   => 1
    };

    # uid агентства берем по первой кампании из списка - все равно класть деньги можно на кампании лишь одного агенства, или
    # на самоходные одного клиента. В функции валидации это проверяется
    if (scalar keys %{$params->{sums}}) {
        $params->{agency_uid} = rbac_is_agencycampaign($rbac, [keys %{$params->{sums}}]->[0]);
    }

    $params = prepare_and_validate_pay_camp($uid, $userID, $rbac, $login_rights, %{$params});

    if ($params->{error}) {
        my $result = {error => $params->{error}};
        return respond_json($r, $result);
    }

    # для нерезидента определяем платил ли он уже
    my $non_resident_payed_before;
    if ($params->{not_resident} eq 'Yes') {
        my %campaigns_cond;
        my %shard = (shard => 'all');

        $campaigns_cond{uid} = $client_chief_uid;
        %shard = (uid => $client_chief_uid);

        $non_resident_payed_before = scalar(@{get_one_column_sql(PPC(%shard), ['SELECT 1 FROM campaigns WHERE sum > 0 AND', \%campaigns_cond, 'LIMIT 1']) || []});
    }

    my $user_info = get_user_data($uid, [qw/fio login email ClientID/]);
    $user_info->{currency} = get_client_currencies($user_info->{ClientID})->{work_currency};

    if (!defined $params->{error_code}) {
        my $eval_res = eval {
            # делаем запрос в баланс
            my ($billing_url);

            my $client_data = get_client_data($params->{client_id}, ['feature_payment_before_moderation']);

            # определяем общие параметры реквеста
            my $request_params = {
                Overdraft => $params->{overdraft_bill},
                ForceUnmoderated => ($client_data->{feature_payment_before_moderation} ? 1 : 0),
            };

            $request_params->{AdjustQty} = 0;
            $request_params->{ReturnPath} = $return_path;

            $request_params->{DenyPromocode} = 1;
            my $main_representatives = get_one_column_sql(PPC(uid => $client_chief_uid),
                ["SELECT DISTINCT uid FROM campaigns", WHERE => {cid => [ $cid ]}]);
            for my $mr_uid (@$main_representatives) {
                if (is_promocode_entry_available($mr_uid)) {
                    $request_params->{DenyPromocode} = 0;
                    last;
                }
            }

            $request_params->{Region} = $tld_domain;
            $billing_url = balance_create_request($userID, $params->{client_id}, $params->{CreateRequest}, $request_params);

            # отправляем нотификации
            MailNotification::save_UID_host($userID);
            for (@{$params->{pay_notification_data}}) {
                mail_notification('camp', 'c_pay_multicurrency', $_->[0], $tld_domain, $_->[1].":".$user_info->{currency}, $_->[2]);
            }

            # обновляем campaigns.sum_to_pay
            do_update_table(PPC(cid => $cid), 'campaigns', {sum_to_pay => $sum}, where => {cid => $cid});

            # Устанавливаем язык интерфейса Баланса

            my $balance_lang = 'ru';

            if (defined($lang_from_request)) {
                $balance_lang = $lang_from_request;
            } elsif ($tld_domain eq 'by') {
                $balance_lang = 'by';
            } elsif ($tld_domain eq 'com' || $tld_domain eq 'tr' ) {
                $balance_lang = 'en';
            }

            $billing_url .= uri_escape_utf8("&LANG=$balance_lang&retpath=".uri_escape_utf8("$return_path&oldsum_$cid=$sum"));
            if (defined($request_scheme)) {
                # заменяем "http://" (в том числе, и перекодированный в retpath) на текущий протокол
                $billing_url =~ s/http(:\/\/|%3A%2F%2)/$request_scheme . $1/ge;
            }

            my $result = {url => $billing_url};
            return respond_json($r, $result);
        };

        if ($@) {
            send_alert("Error in cmd_payforall: $@", 'cmd_payforall');
            my $message = iget("Извините, функция оплаты в данный момент недоступна.") . "\n" .
                iget("Попробуйте перезагрузить страницу.") . "\n" .
                iget("Если это не помогает зайдите позже.");
            my $result = {error => $message};
            return respond_json($r, $result);
        }

        return $eval_res;
    }

    my %redirect_params;
    hash_copy \%redirect_params, $params, qw/error_code error_param error_cid error_region error_min_shows currency product_id/;
    hash_merge \%redirect_params, $params->{error_fields};
    $redirect_params{"oldsum_$cid"} = $sum;
    if ($cid && $params->{error_code}) {
        $redirect_params{cmd} = 'pay';
        $redirect_params{cid} = $req_params->{cid};
        $redirect_params{topay} = $req_params->{sum};
    } else {
        $redirect_params{cmd} = 'showCamps';
    }

    $redirect_params{is_direct} = 1;

    my $result = {pay_error => 1};
    $result->{error} = pay_error_code_2_text(%redirect_params);

    return respond_json($r, $result);
}

1;
