package Intapi::PrepareAndValidatePayCamp;

=head1 NAME

    Intapi::PrepareAndValidatePayCamp

=head1 DESCRIPTION

=cut

use Direct::Modern;

use MoneyTransfer;

use PrimitivesIds;
use RBACElementary;
use RBACDirect;

use Yandex::DBTools;
use Settings;

use Yandex::Validate qw/is_valid_id is_valid_float/;

=head2 handler

    Валидация оплаты кампании

    Параметры:
        uid - клиент
        UID - оператор
        cid - кампания для платы
        sum - сумма с НДС для оплаты

=cut

sub handler {
    my ($r, $multiform) = @_;
    my $param = JSON::from_json($r->content, {utf8 => 1});

    my $error = '';

    if (!is_valid_id($param->{uid})) {
        $error .= "uid is not valid id; ";
    }
    if (!is_valid_id($param->{cid})) {
        $error .= "cid is not valid id; ";
    }
    if (!is_valid_id($param->{UID})) {
        $error .= "UID is not valid id; ";
    }
    if (!is_valid_float($param->{sum})) {
        $error .= "sum is not valid float";
    }

    if ($error) {
        return { text => $error, code => 400 };
    }

    my $uid = $param->{uid};

    my $client_id = get_clientid(uid => $uid);

    my $chief_uid = rbac_get_chief_rep_of_client($client_id);

    my $cid = $param->{cid};
    my $sum = $param->{sum};
    my $UID = $param->{UID};
    my $agency_uid = rbac_is_agencycampaign(undef, $cid);
    my $client_chief_uid = $chief_uid;

    my $role_hash = rbac_who_is_detailed(undef, $UID) || {};
    my $role = $role_hash->{role};

    my $camp_uid = get_one_field_sql(PPC(cid => $cid), ['SELECT uid FROM campaigns', where => {cid => $cid}]);

    my $result = prepare_and_validate_pay_camp($uid, $UID, undef, { super_control => ($role eq 'super') },
        sums => { $cid => $sum },
        sums_with_nds => 1,
        agency_uid => $agency_uid,
        client_chief_uid => $client_chief_uid,
        custom_min_pay => 1,
        multiuser => ($uid ne ($camp_uid // $uid)),
    );

    return {text => JSON::to_json($result), code => 200};
}

1;
