package Intapi::SearchBanners;

=head1 NAME

    jsonrpc/SearchBanners

=head1 DESCRIPTION

    Поиск баннеров в нашей базе и в БК

=cut

use strict;
use warnings;
use utf8;

use Settings;

use SearchBanners;
use Yandex::HashUtils qw/hash_cut/;

=head2 new

=cut

sub new
{
    return bless {};
}

=head2 advanced_search

    Поиск баннеров по фразе, домену, логину клиента, тексту баннера, номеру баннера, группы, кампании и проч.
    Принимает хеш с такими же параметрами, как и SearchBanners::search_banners.

    curl -s 'http://9665.beta2.direct.yandex.ru/jsonrpc/SearchBanners' -d '
    {
        "method": "advanced_search",
        "params": {
            "criteria": [
                {
                    "key": "campaign",
                    "values": [10875431, 10875432]
                },
                {
                    "key": "login",
                    "values": ["electroburg-rw"]
                }
            ],
            "activeonly": "0",
            "short": "1",
            "include_currency_archived_campaigns": "1",
            "exact_domain": "0",
            "limit": "2"
        }
    }' | json_xs

=cut

sub advanced_search {
    my ($self, $params, $procedure, @extra_args) = @_;

    if (!$params || ref($params) ne 'HASH' || !%$params) {
        die {
            message => "Hash of search conditions expected",
            data => {code => 400},
        };
    }
    my $criteria = delete $params->{criteria};
    $params = hash_cut $params, @SearchBanners::ALLOWED_PARAMS;
    unless ($criteria && @$criteria) {
        die {
            message => "Search criteria cannot be empty",
            data => {code => 400},
        };
    }

    return search_banners($criteria, $params);
}

=head2 search

    WARNING: Метод устарел и проксирует свои запросы на advanced_search, не нужно им пользоваться
    Поиск баннеров по фразе, домену, номеру баннера, кампании и группы.

    curl -s 'http://9665.beta2.direct.yandex.ru/jsonrpc/SearchBanners' -d '
    {
        "method": "search",
        "params": {
            "activeonly": "0",
            "what": "campaign",
            "short": "1",
            "include_currency_archived_campaigns": "1",
            "exact_domain": "0",
            "limit": "2",
            "text_search": "10875431"
        }
    }' | json_xs

=cut

sub search {
    my ($self, $params, $procedure, @extra_args) = @_;

    if (!$params || ref($params) ne 'HASH' || !%$params) {
        die {
            message => "Hash of search conditions expected",
            data => {code => 400},
        };
    }
    my ($criteria, $advanced_params) = convert_old_style_params($params);
    $advanced_params->{criteria} = $criteria;
    return $self->advanced_search($advanced_params);
}

1;
