package Intapi::TestDataGenerator;

# $Id$

=head1 NAME


=head1 DESCRIPTION


=cut

use strict;
use warnings;

use Yandex::DBTools;
use Yandex::HashUtils;

use Settings;
use ShardingTools;

use Campaign::Types ();

use utf8;

sub new
{
    bless {};
}

=head2

wget -qO - 'http://8800.beta1.direct.yandex.ru/secret-jsonrpc/TestDataGenerator?method=get_users&params={"easy":1}'

=cut

sub get_campaigns {
    my ($self, $params, $procedure, @extra_args) = @_;

    my $opt_type            = Campaign::Types::camp_kind_in(type => $params->{'type'}, 'with_currency')
                                ? $params->{'type'}
                                : 'text';
    my $opt_phrases_count   = $params->{'phrases_count'};
    my $opt_metrika_goals   = $params->{'metrika_goals'};
    my $opt_status          = $params->{'status'};
    my $opt_nonzero_balance = $params->{'nonzero_balance'};

    my $random_shard = _random_shard();

    my $where = {
        statusEmpty => 'No',
        type        => $opt_type,
        cid__ge     => int rand 10_000_000,
    };

    if ($opt_status) {
        if ( $opt_status eq 'moderate' ) {
            $where = hash_merge( $where, {
                'statusShow'         => 'Yes',
                'statusModerate__in' => [ qw( Ready Sent ) ],
            } );
        } else {
            $where->{'statusModerate__not_in'} = [ qw( Ready Sent ) ];

            if ( $opt_status eq 'active' ) {
                $where = hash_merge( $where, {
                    'statusShow'   => 'Yes',
                    'statusActive' => 'Yes',
                } );
            } elsif ( $opt_status eq 'inactive' ) {
                $where->{'_OR'} = {
                    'statusShow'   => 'No',
                    'statusActive' => 'No',
                };
            }
        }
    }

    if ($opt_nonzero_balance) {
        $where->{'sum__dont_quote__ge'} = 'sum_spent + 10';
    }

    my $initial_camps = get_all_sql( PPC( shard => $random_shard ), [
        'select cid, NULL as phrases_count from campaigns',
        'where' => $where,
        'limit' => 20_000
    ] );

    return [] unless $initial_camps && @$initial_camps;

    my %camp_rows;
    foreach my $camp (@$initial_camps) {
        my $cid = $camp->{'cid'};
        $camp_rows{$cid} = $camp;
    }

    my @filtered_camp_ids = keys %camp_rows;

    if ( defined $opt_phrases_count && $opt_phrases_count >= 0 ) {
        my $min_phrases_count = $opt_phrases_count * 0.8;
        my $max_phrases_count = $opt_phrases_count * 1.2;

        my $opt_phrases_count_rows = get_all_sql( PPC( shard => $random_shard ),
            [
                'select cid, count(*) as count_phrases from phrases',
                'where'    => { 'cid' => \@filtered_camp_ids },
                'group by' => 'cid',
            ],
        );
        $opt_phrases_count_rows ||= [];

        my %phrases_count_info;
        foreach my $row (@$opt_phrases_count_rows) {
            $phrases_count_info{ $row->{'cid'} } = $row->{'count_phrases'};
        }

        my @old_camp_ids = @filtered_camp_ids;
        @filtered_camp_ids = ();
        foreach my $cid (@old_camp_ids) {
            my $camp_count_phrases = $phrases_count_info{$cid} || 0;
            next if $camp_count_phrases < $min_phrases_count ||
                $camp_count_phrases > $max_phrases_count;

            push @filtered_camp_ids, $cid;
            $camp_rows{$cid}->{'phrases_count'} = $camp_count_phrases;
        }
    }
    return [] unless @filtered_camp_ids;

    if ($opt_metrika_goals) {
        my @old_camp_ids = @filtered_camp_ids;
        my $found_camp_ids = get_one_column_sql( PPC( shard => $random_shard ),
            [
                'select distinct cid from camp_metrika_goals',
                'where' => {
                    'cid'             => \@old_camp_ids,
                    'goals_count__ge' => 40,
                },
            ]
        ) || [];

        @filtered_camp_ids = @$found_camp_ids;
    }
    return [] unless @filtered_camp_ids;

    if ( @filtered_camp_ids > 10 ) {
        splice @filtered_camp_ids, 10;
    }

    my @camps = map { $camp_rows{$_} } @filtered_camp_ids;
    return \@camps;
}

sub get_banners {
    my ($self, $params, $procedure, @extra_args) = @_;

    my $opt_status           = $params->{'status'};
    my $opt_with_vcard       = $params->{'with_vcard'};
    my $opt_with_href        = $params->{'with_href'};
    my $opt_with_sitelinks   = $params->{'with_sitelinks'};
    my $opt_with_image       = $params->{'with_image'};
    my $opt_with_retargeting = $params->{'with_retargeting'};
    my $opt_lowctr_disabled  = $params->{'lowctr_disabled'};

    my $random_shard = _random_shard();

    # дальше в SQL-запросе: banners as b, phrases as p
    my $where = {};

    my $matching_pids = [];
    if ($opt_lowctr_disabled) {
        $matching_pids = get_one_column_sql( PPC( shard => $random_shard ),
            [
                'select distinct pid from bs_auction_stat',
                'where' => {
                    'pid__ge' => int rand 100_000_000,
                    'rank'    => 0,
                },
                'limit' => 20_000,
            ]
        ) || [];

        return [] unless @$matching_pids;
    }

    if (@$matching_pids) {
        $where->{'p.pid'} = $matching_pids;
    } else {
        $where->{'b.bid__ge'} = int rand 300_000_000;
    }

    # краткость: пустое opt_status и неопределённое opt_status
    # совершенно одинаково не равны никакой осмысленной строке
    $opt_status ||= '';

    if ( $opt_status eq 'active' ) {
        $where = hash_merge( $where, {
            'b.statusPostModerate' => 'Yes',
            'p.statusPostModerate' => 'Yes',
            'b.statusShow'         => 'Yes',
        } );
    } elsif ( $opt_status eq 'stopped') {
        $where = hash_merge( $where, {
            'b.statusPostModerate' => 'Yes',
            'p.statusPostModerate' => 'Yes',
            'b.statusShow'         => 'No',
        } );
    } elsif ( $opt_status eq 'moderate_rejected' ) {
        $where = hash_merge( $where, {
            'b.statusModerate__in' => [ qw( Yes No ) ],
            'p.statusModerate__in' => [ qw( Yes No ) ],
            '_OR' => {
                'b.statusPostModerate' => 'No',
                'p.statusPostModerate' => 'No',
            },
        } );
    } elsif ( $opt_status eq 'archived' ) {
        $where->{'b.statusArch'} = 'Yes';
    }

    if ($opt_with_vcard) {
        $where->{'b.vcard_id__is_not_null'} = 1;
    }

    if ($opt_with_href) {
        $where->{'b.href__is_not_null'} = 1;
    }

    if ($opt_with_sitelinks) {
        $where->{'b.sitelinks_set_id__is_not_null'} = 1;
    }

    my $initial_banners = get_all_sql( PPC( shard => $random_shard ), [
        'select b.bid, p.pid ' .
        'from banners as b inner join phrases as p using(pid)',
        'where' => $where,
        'limit' => 20_000,
    ] );

    return [] unless $initial_banners && @$initial_banners;

    my %banner_rows;
    foreach my $banner (@$initial_banners) {
        $banner_rows{ $banner->{'bid'} } = $banner;
    }

    my @filtered_bids = keys %banner_rows;

    if ($opt_with_image) {
        my @old_bids = @filtered_bids;
        my $found_bids = get_one_column_sql( PPC( shard => $random_shard ),
            [
                'select distinct bid from banner_images',
                'where' => { 'bid' => \@old_bids },
            ]
        ) || [];

        @filtered_bids = @$found_bids;
    }

    if ($opt_with_retargeting) {
        my @old_bids = @filtered_bids;

        my ( %pid_map, %uniq_pids );
        foreach my $bid (@filtered_bids) {
            my $row = $banner_rows{$bid};
            my $pid = $row->{'pid'};

            $pid_map{$bid} = $pid;
            $uniq_pids{$pid} = 1;
        }

        my $found_pids = get_one_column_sql( PPC( shard => $random_shard ),
            [
                'select distinct pid from bids_retargeting',
                'where' => { 'pid' => [ keys %uniq_pids ] },
            ]
        ) || [];

        my %found_pid = map { $_ => 1 } @$found_pids;
        @filtered_bids = ();
        foreach my $bid (@old_bids) {
            my $pid = $pid_map{$bid};
            next unless $found_pid{$pid};
            push @filtered_bids, $bid;
        }
    }

    if ( @filtered_bids > 10 ) {
        splice @filtered_bids, 10;
    }

    my @banners = map { $banner_rows{$_} } @filtered_bids;
    return \@banners;
}

sub _random_shard {
    my @shards = ppc_shards();
    return $shards[ int rand scalar @shards ];
}

1;
