package Intapi::TestUsers;
use strict;
use warnings;

# $Id$

=head1 DESCRIPTION
    
    get_all - выдает список тестовых пользователей, с параметром ext выдает вместе с ними еще продовых суперов
 
=cut

use Settings;
use TestUsers qw/get_all/;
use User qw/get_users_data/;
use Primitives;
use Yandex::DBTools qw/get_all_sql/;

sub new {
    my ($class) = @_;
    return bless {}, $class;
}

sub get_all {
    my ($self, $params) = @_;
    my @result;

    my $rows = TestUsers::get_all();
    my $users_data = get_users_data([map {$_->{uid} } @{$rows}], [qw/login/]);
    for my $row (@{$rows}){
        # get_login_by_uid_passport надо делать, потому что скорее всего пользователя в нашей базе нет, и логин можно узнать только из Паспорта
        my $login = $users_data->{$row->{uid}}->{login} || get_login_by_uid_passport($row->{uid}) ;
        next unless $login;
        push @result, { 
            login => $login, 
            domain_login => $row->{domain_login}, 
            role => $row->{role},
        };
    }
    
    if ($params->{ext}) {
        my $prod_supers_uids = get_all_sql(PPC( shard => 'all' ), ['select u.uid from users u join clients cl on u.ClientId=cl.ClientId where role = "super"']);
        my $data = get_users_data([map {$_->{uid} } @{$prod_supers_uids}], [qw/login domain_login/]);
        push @result, map { { login => $data->{$_}->{login}, domain_login => $data->{$_}->{domain_login}, role => "super"} } keys %$data;
    }

    return \@result;
}

1;
