package InterfaceConsts;

=head1 DESCRIPTION

    Константы, которые используются в интерфейсе.

    Передаются на клиента в window.CONSTS, куда попадают из файла, генерируемого protected/maintenance/export_consts_to_js.pl
    Передаётся в шаблоны в виде ключа CONSTS на верхнему уровне приходящих $vars

=cut

use strict;
use warnings;
use utf8;

use Settings;
use Direct::Validation::Campaigns::Constraints ();
use Direct::Validation::SitelinksSets ();
use Direct::Validation::HierarchicalMultipliers ();
use Direct::Validation::Banners ();
use Direct::Validation::Keywords ();
use Direct::Validation::AdGroupsCpmBanner ();
use Direct::Model::AdGroupCpmOutdoor ();
use Tag ();
use Currencies ();
use Currency::Rate ();
use Currency::Texts ();
use MobileContent qw//;
use PlacePrice;
use RBACDirect;
use Stat::Const ();
use Direct::Creatives::Dict qw//;

use Yandex::DateTime;

=head2 get_interface_consts

    $consts_hash_ref = InterfaceConsts::get_interface_consts();

=cut
sub get_interface_consts {
    return {
        MIN_PHRASE_RANK_WARNING            => $Settings::MIN_PHRASE_RANK_WARNING,
        MAX_PHRASE_RANK_WARNING            => $Settings::MAX_PHRASE_RANK_WARNING,
        SITELINKS_MAX_LENGTH               => $Direct::Validation::SitelinksSets::SITELINKS_MAX_LENGTH,
        ONE_SITELINK_MAX_LENGTH            => $Direct::Validation::SitelinksSets::ONE_SITELINK_MAX_LENGTH,
        ONE_SITELINK_DESC_MAX_LENGTH       => $Direct::Validation::SitelinksSets::ONE_SITELINK_DESC_MAX_LENGTH,
        SITELINKS_NUMBER                   => 4,
        MAX_URL_LENGTH                     => $Settings::MAX_URL_LENGTH,
        MAX_DOMAIN_LENGTH                  => $Settings::MAX_DOMAIN_LENGTH,
        KAZ_LETTERS                        => $Settings::KAZ_LETTERS,
        RUS_LETTERS                        => $Settings::RUS_LETTERS,
        UKR_NATIVE_LETTERS                 => $Settings::UKR_NATIVE_LETTERS,
        TR_NATIVE_LETTERS                  => $Settings::UNIQUE_TR_LETTERS,
        DE_NATIVE_LETTERS                  => $Settings::UNIQUE_DE_LETTERS,
        BEL_NATIVE_LETTERS                 => $Settings::BEL_NATIVE_LETTERS,
        ALLOW_LETTERS                      => $Settings::ALLOW_LETTERS,
        ALLOW_BANNER_LETTERS               => $Settings::ALLOW_BANNER_LETTERS_STR,
        NARROW_SYMBOLS                     => $Settings::NARROW_SYMBOLS_STR,
        MAX_TAGS_FOR_BANNER                => $Tag::MAX_TAGS_FOR_BANNER,
        CAMPAIGN_MINUS_WORDS_LIMIT         => $Settings::CAMPAIGN_MINUS_WORDS_LIMIT,
        GROUP_MINUS_WORDS_LIMIT            => $Settings::GROUP_MINUS_WORDS_LIMIT,
        MIN_GOALS_ON_CAMPAIGN              => $Settings::MIN_GOALS_ON_CAMPAIGN,
        MAX_TAG_LENGTH                     => $Tag::MAX_TAG_LENGTH,
        MAX_TAGS_FOR_CAMPAIGN              => $Tag::MAX_TAGS_FOR_CAMPAIGN,
        MAX_RETARGETINGS_ON_CLIENT         => $Settings::MAX_RETARGETINGS_ON_CLIENT,
        MAX_RETARGETING_GROUPS             => $Settings::MAX_RETARGETING_GROUPS,
        MAX_RETARGETING_GOALS_IN_GROUP     => $Settings::MAX_RETARGETING_GOALS_IN_GROUP,
        MAX_RETARGETING_GOAL_TIME_DAYS     => $Settings::MAX_RETARGETING_GOAL_TIME_DAYS,
        MAX_MONEY_WARNING_VALUE            => $Settings::MAX_MONEY_WARNING_VALUE,
        MAX_PHRASE_LENGTH                  => $Settings::MAX_PHRASE_LENGTH,
        MAX_WORD_LENGTH                    => $Direct::Validation::Keywords::MAX_WORD_LENGTH,
        MAX_TITLE_LENGTH                   => $Settings::MAX_TITLE_LENGTH,
        NEW_MAX_TITLE_LENGTH               => $Settings::NEW_MAX_TITLE_LENGTH,
        NEW_MAX_TITLE_LENGTH_MOBILE        => $Settings::NEW_MAX_TITLE_LENGTH,
        MAX_TITLE_EXTENSION_LENGTH         => $Settings::MAX_TITLE_EXTENSION_LENGTH,
        MAX_TITLE_LENGTH_MOBILE            => $Settings::MAX_TITLE_LENGTH,
        MAX_TITLE_LENGTH_CONTENT_PROMOTION => $Settings::MAX_TITLE_LENGTH_CONTENT_PROMOTION,
        MAX_TITLE_UNINTERRUPTED_LENGTH     => $Settings::MAX_TITLE_UNINTERRUPTED_LENGTH,
        MAX_BODY_LENGTH                    => $Settings::MAX_BODY_LENGTH,
        MAX_BODY_LENGTH_MOBILE             => $Settings::MAX_BODY_LENGTH_MOBILE,
        MAX_BODY_LENGTH_CONTENT_PROMOTION  => $Settings::MAX_BODY_LENGTH_CONTENT_PROMOTION,
        MAX_BODY_UNINTERRUPTED_LENGTH      => $Settings::MAX_BODY_UNINTERRUPTED_LENGTH,
        MAX_NUMBER_OF_NARROW_CHARACTERS    => $Settings::MAX_NUMBER_OF_NARROW_CHARACTERS,
        MAX_URL_LENGTH                     => $Settings::MAX_URL_LENGTH,
        OPENSTAT_LABEL                     => $Settings::OPENSTAT_LABEL,
        DEFAULT_CREATIVE_COUNT_LIMIT       => $Settings::DEFAULT_CREATIVE_COUNT_LIMIT,
        MAX_OPEN_FOR_EDIT_BANNERS          => $Settings::MAX_OPEN_FOR_EDIT_BANNERS,
        PRICE_PLACES                       => \%PlacePrice::PLACES,
        POSITION_CTR_CORRECTION_BY_PLACE   => \%PlacePrice::POSITION_CTR_CORRECTION_BY_PLACE,
        ENTRY_PLACES => PlacePrice::get_entry_places_for_js(),
        BSAUCTION_PLACE_LAYOUT => \%PlacePrice::BSAUCTION_PLACE_LAYOUT,
        DEMOGRAPHY_MULTIPLIER_AGES => $Direct::Validation::HierarchicalMultipliers::DEMOGRAPHY_MULTIPLIER_AGES,
        DEMOGRAPHY_MULTIPLIER_GENDERS => $Direct::Validation::HierarchicalMultipliers::DEMOGRAPHY_MULTIPLIER_GENDERS,
        MOBILE_MULTIPLIER_OS_TYPES => $Direct::Validation::HierarchicalMultipliers::MOBILE_MULTIPLIER_OS_TYPES,
        INVENTORY_MULTIPLIER_TYPES => $Direct::Validation::HierarchicalMultipliers::INVENTORY_MULTIPLIER_TYPES,
        BANNER_TYPE_MULTIPLIER_TYPES => $Direct::Validation::HierarchicalMultipliers::BANNER_TYPE_MULTIPLIER_TYPES,
        WEATHER_MULTIPLIER_CONDITION_TYPES => $Direct::Validation::HierarchicalMultipliers::WEATHER_MULTIPLIER_CONDITION_TYPES,
        WEATHER_MULTIPLIER_MAX_CONDITION_COUNT => $Direct::Validation::HierarchicalMultipliers::WEATHER_MULTIPLIER_MAX_CONDITION_COUNT,
        WEATHER_MULTIPLIER_CONSTRAINTS => $Direct::Validation::HierarchicalMultipliers::WEATHER_MULTIPLIER_VALUES,
        currencies => Currencies::get_consts_for_js(),
        currencies_order => [Currencies::get_currencies_list()],
        fixed_currency_rates => Currency::Rate::get_fixed_rates_for_js(),
        currency_texts_description => Currency::Texts::get_currency_texts_description_for_js(),
        MOBILE_OS_VERSIONS => \%MobileContent::OS_VERSIONS,
        NEWS_ARCHIVE_URL => $Settings::NEWS_ARCHIVE_URL,
        ROLE_NAMES => \%RBACDirect::ROLE_NAMES,
        MAX_CALLOUT_LENGTH => $Settings::MAX_CALLOUT_LENGTH,
        MAX_CALLOUT_LENGTH_ON_BANNER => $Settings::MAX_CALLOUT_LENGTH_ON_BANNER,
        MAX_CALLOUTS_COUNT_ON_BANNER => $Settings::MAX_CALLOUTS_COUNT_ON_BANNER,
        MAX_DISPLAY_HREF_LENGTH => $Direct::Validation::Banners::MAX_DISPLAY_HREF_LENGTH,
        MAX_WORDS_IN_KEYPHRASE => $Settings::MAX_WORDS_IN_KEYPHRASE,
        # константы статистики
        BS_EXT_PHRASE_SINCE_DATE         => date($Stat::Const::BS_EXT_PHRASE_BORDER_DATE)->add(days => 1)->ymd(''),
        BS_SEARCH_QUERIES_SINCE_DATE     => date($Stat::Const::BS_SEARCH_QUERIES_BORDER_DATE)->add(days => 1)->ymd(''),
        BS_SEARCH_QUERIES_LAST_DAYS      => $Stat::Const::BS_SEARCH_QUERIES_LAST_DAYS,
        BUSINESS_TYPES                   => $Direct::Creatives::Dict::BUSINESS_TYPES,
        # константы охватного продукта
        MAX_RF                           => $Direct::Validation::Campaigns::Constraints::CPM_RF_MAX,
        MAX_RF_RESET                     => $Direct::Validation::Campaigns::Constraints::CPM_RF_RESET_MAX,

        PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO => $Direct::Validation::Campaigns::Constraints::PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO,
        PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO_DEFAULT_VALUE => $Direct::Validation::Campaigns::Constraints::PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO_DEFAULT_VALUE,
        VIDEO_GOALS_AUDITORY_TYPES       => $Direct::Validation::AdGroupsCpmBanner::VIDEO_GOALS_AUDITORY_TYPES,
        GOALS_MAX_NUM                    => $Stat::Const::GOALS_MAX_NUM,
        OUTDOOR_GOALS_AUDITORY_TYPES 	 => $Direct::Model::AdGroupCpmOutdoor::OUTDOOR_GOALS_AUDITORY_TYPES,
	AUDIO_GOALS_AUDITORY_TYPES       => $Direct::Validation::AdGroupsCpmBanner::AUDIO_GOALS_AUDITORY_TYPES,
        INDOOR_GOALS_AUDITORY_TYPES      => $Direct::Validation::AdGroupsCpmBanner::INDOOR_GOALS_AUDITORY_TYPES,

        ENGAGED_SESSION_GOAL_ID               => $Settings::ENGAGED_SESSION_GOAL_ID,
        MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID => $Settings::MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID,
    };
}

1;
