package InternalAdManagers;
use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;

use Settings;

my @RELATION_TYPES = qw( internal_ad_publisher internal_ad_reader );

=head2 get_accessible_products

 возвращает хэшмэп {
    ClientID => {
        relation_id => relation_id из clients_relations,
        type => type из clients_relations,
        place_ids => [ все place_id из internal_ad_manager_place_access ],
    }

=cut

sub get_accessible_products {
	my ($manager_client_id) = @_;

	my $relations = get_all_sql( PPC( shard => 'all' ), [
		'SELECT relation_id, client_id_to, type',
		'FROM clients_relations',
		WHERE => { client_id_from => $manager_client_id, type => \@RELATION_TYPES },
	]);

    my %relation_id_by_client_id_to =
        map { $_->{client_id_to} => $_->{relation_id} }
        grep { $_->{type} eq 'internal_ad_publisher' } # доступ по плейсам только у них
        @$relations;

    my %place_ids_by_relation_id = ();

    foreach_shard 'ClientID' => [ keys %relation_id_by_client_id_to ], sub {
        my ( $shard, $client_ids ) = @_;
        my @relation_ids = map { $relation_id_by_client_id_to{$_} } @$client_ids;
        my $place_rows = get_all_sql( PPC( shard => $shard ), [
            'SELECT relation_id, place_id',
            'FROM internal_ad_manager_place_access',
            WHERE => { relation_id => \@relation_ids },
        ] );
        
        for my $row (@$place_rows) {
            my $relation_id = $row->{relation_id};
            $place_ids_by_relation_id{$relation_id} ||= [];
            push @{ $place_ids_by_relation_id{$relation_id} }, $row->{place_id};
        }
    };

    my %result;

    for my $relation (@$relations) {
        my $relation_id = $relation->{relation_id};
        my $place_ids = $place_ids_by_relation_id{$relation_id} || [];

        $result{ $relation->{client_id_to} } = {
            relation_id => $relation_id,
            type => $relation->{type},
            place_ids => $place_ids,
        };
    }

    return \%result;
}

=head2 filter_accessible_client_ids

возвращает хэшмэп { ClientID => type из clients_relations }
для выбранных продуктов

=cut

sub filter_accessible_client_ids {
    my ( $manager_client_id, $product_client_ids ) = @_;

    return {} unless @$product_client_ids;
    return get_hash_sql( PPC( ClientID => $product_client_ids ), [
        'SELECT client_id_to, type FROM clients_relations',
        WHERE => {
            client_id_from => $manager_client_id,
            client_id_to => $product_client_ids,
            type => \@RELATION_TYPES,
        },
    ]);
}

1;
