#!/usr/bin/perl

package JSSchema::Result;

use Direct::Modern;
use Mouse;
use Carp qw//;
use Scalar::Util qw//;


has errors => (
    is => 'ro',
    isa => 'Maybe[HashRef]',
    default => sub {return {}},
);

use overload
    'bool' => sub {$_[0]->is_valid;},
    'eq'   => sub {$_[0]->is_valid == $_[1]};


around BUILDARGS => sub {
    my ($orig, $class, $jsv_result) = @_;

    my $errors;
    Carp::croak sprintf 'JSV::Result instance required but % given', $jsv_result
        unless (Scalar::Util::blessed($jsv_result) && $jsv_result->isa('JSV::Result'));
    unless ($jsv_result) {
        my $jsv_errors = $jsv_result->get_error_map;
        foreach my $pointer (keys %$jsv_errors) {
            my $p = $pointer gt '' ? $pointer : '/';
            $errors->{$p} = {
                map { $_ => $jsv_errors->{$pointer}->{$_} } qw/message keyword/
            };
            $errors->{$p}->{data} = $jsv_errors->{$pointer}->{instance} unless ref $jsv_errors->{$pointer}->{instance};
            $errors->{$p}->{data_type} = JSV::Util::Type::detect_instance_type($jsv_errors->{$pointer}->{instance});
        }
    }
    return $class->$orig(errors => $errors);
};

=head2 is_valid
 
 При отсутствии ошибок валидации возвращает 1, при наличии - 0.
 
=cut

sub is_valid {
    my ($self) = @_;
    return !($self->errors && keys %{$self->errors});
}


1
