package JavaIntapi::AutobudgetRestartCalculate;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:AutobudgetRestartCalculate');
has '+http_method' => (default => 'POST');
has 'campaigns' => (is => 'ro', isa => 'ArrayRef[HashRef]');

sub _method {'bs-autobudget-restart/calculate'}

sub _get_url_params {undef}

sub _prepare {
    my ($self) = @_;
    return $self->campaigns;
}

sub _postprocess {
    my ($self, $result, $error) = @_;
    
    if ($result && @$result) {
        return +{ map {$_->{cid} => $_} @$result };
    } else {
        die 'error in call_intapi_java(' . $self->_method() . '): ' . ($error // '');
    }
}

1;
