package JavaIntapi::CheckOrganizationsAccess;

use Direct::Modern;
use Mouse;

use JSON 'to_json';
use Yandex::ORM::Types;

extends 'JavaIntapiClientBase';

=head2

    Возвращает информацию о доступности организаций Справочника для пользователей.

    Пример результата:
        https://8080.beta1.intapi.direct.yandex.ru/docs/swagger-ui.html#!/organizations-controller/check_access

=cut

has '+http_method' => (default => 'POST');
has 'uids' => (is => 'ro', isa => 'ArrayRef[Id]');
has 'permalinkIds' => (is => 'ro', isa => 'ArrayRef[Id]');

sub _method { 'organizations/check_access' }

sub _get_url_params {
    undef
}

sub _prepare {
    my ($self) = @_;
    return {
        uids => $self->uids,
        permalinkIds => $self->permalinkIds
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if ( !$result->{success} || !$result->{result} ) {
        die to_json($result);
    }

    return $result->{result};
}

1;
