package JavaIntapi::CheckPhoneVerified;

use Direct::Modern;
use Mouse;

use JSON 'to_json';
use Yandex::ORM::Types;

extends 'JavaIntapiClientBase';

=head2

    Возвращает информацию о подтвержденности телефона пользователя.

=cut

has '+http_method' => (default => 'POST');
has 'uid' => (is => 'ro', isa => 'Id');
has 'phoneId' => (is => 'ro', isa => 'Id');

sub _method { 'user_phones/check_verified' }

sub _get_url_params {
    undef
}

sub _prepare {
    my ($self) = @_;
    return {
        uid => $self->uid,
        phoneId => $self->phoneId
    };
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    die $error if $error;

    if (!$result->{success}) {
        die to_json($result);
    }

    return $result;
}

1;

