package JavaIntapi::CheckPhoneVerifiedBulk;

use Direct::Modern;
use Mouse;

use JSON 'to_json';
use Yandex::ORM::Types;

extends 'JavaIntapiClientBase';

=head2

    Возвращает информацию о подтвержденности телефонов пользователей.

=cut

has '+http_method' => (default => 'POST');
has 'phone_id_by_uid' => (is => 'ro', isa => 'HashRef');

sub _method { 'user_phones/check_verified_bulk' }

sub _get_url_params {
    undef
}

sub _prepare {
    my ($self) = @_;

    my $request_items = [ map { { 'uid' => $_, 'phoneId' => $self->phone_id_by_uid->{$_} } } keys %{$self->phone_id_by_uid} ];

    return {
        requestItems => $request_items
    };
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    die $error if $error;

    if (!$result->{success}) {
        die to_json($result);
    }

    my $response_items = $result->{responseItems};
    my $converted_result = { map { $_->{uid} => $_ } @$response_items };

    return $converted_result;
}

1;

