package JavaIntapi::CreateMobileApp;
use Direct::Modern;
use Mouse;

use JSON 'to_json';

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'POST');
has 'client_id' => (is => 'ro', isa => 'Id');
has 'entities'      => (is => 'ro', isa => 'ArrayRef[HashRef]');

sub _method { 'mobile_app/createMobileApp' }

sub _get_url_params { undef }

sub _prepare {
	my ($self) = @_;
    return {
    	clientId => $self->client_id,
    	entities => $self->entities,
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if ( !$result->{success} || !$result->{result} ) {
        die to_json($result);
    }

    return $result->{result};
}

1;
