package JavaIntapi::CreatePostviewOfflineReport;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:create_postview_offline_report');
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'cids'    => (is => 'rw', isa => 'ArrayRef[Id]');
has 'date_from'    => (is => 'rw', isa => 'Str');
has 'date_to'    => (is => 'rw', isa => 'Str');

sub _method { 'client_offline_report/postview/create' }

sub _get_url_params {}

sub _prepare {
    my ($self) = @_;
    my %result;
    $result{operator_uid} = $self->operator_uid;
    $result{cids} = $self->cids;
    $result{date_from} = $self->date_from;
    $result{date_to} = $self->date_to;
    for my $field ('date_from', 'date_to') {
        $result{$field} =~ s/^(\d{4})(\d{2})(\d{2})$/$1-$2-$3/;
    }
    return \%result;
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ($result && %$result) {
        return $result;
    } else {
        die "error in call_intapi_java('".$self->_method."'): " . ($error // '');
    }
}

__PACKAGE__->meta->make_immutable;

1;
