package JavaIntapi::CreateVcards;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

use JavaIntapi::ValidateVcards qw//;


has '+profile_name' => (default => 'intapi_java:create_vcards');
has '+warn_if_request_failed' => (default => 0);
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'client_id'    => (is => 'rw', isa => 'Id');

sub _method { 'vcard/create_vcards' }

sub _get_url_params {
    my ($self) = @_;
    return {operator_uid => $self->operator_uid, client_id => $self->client_id};
}

sub _prepare {
    my ($self) = @_;
    return JavaIntapi::ValidateVcards->_convert_vcards_to_java_model($self->items);
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ($result && @$result) {
        return $result;
    } else {
        die "error in call_intapi_java('vcard/create_vcards'): " . ($error // '');
    }
}

__PACKAGE__->meta->make_immutable;

1;
