package JavaIntapi::DeletePostviewOfflineReport;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:delete_postview_offline_report');
has 'client_id' => (is => 'ro', isa => 'Id');
has 'report_id' => (is => 'ro', isa => 'Id');

sub _method { 'client_offline_report/postview/delete' }

sub _get_url_params {}

sub _prepare {
    my ($self) = @_;
    return {
        client_id => $self->client_id,
        report_id => $self->report_id,
    };
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ($result) {
        return $result;
    } else {
        die "error in call_intapi_java('".$self->_method."'): " . ($error // '');
    }
}

__PACKAGE__->meta->make_immutable;

1;
