package JavaIntapi::GenerateObjectIds;

use Direct::Modern;
use Mouse;
use Yandex::ORM::Types;
use Mouse::Util::TypeConstraints;

extends 'JavaIntapiClientBase';
my %OBJECT_NAME_TO_SIGNATURE_MAP = (
    adgroup => 'pid',
    banner  => 'bid',
    banner_creative => 'banner_creative_id',
    dynamic_rule => 'dyn_id',
    image => 'image_id',
    images_pool => 'banner_images_pool_id',
    multiplier => 'hierarchical_multiplier_id',
    performance_filter => 'perf_filter_id',
    phrase  => 'phid',
    retargeting => 'ret_id',
    retargeting_condition => 'ret_cond_id',
    sitelink => 'sl_id',
    sitelinks_set => 'sitelinks_set_id',
    vcard => 'vcard_id',
);

enum 'KnownObjects', [keys %OBJECT_NAME_TO_SIGNATURE_MAP];
my %object_name_by_signature = (reverse %OBJECT_NAME_TO_SIGNATURE_MAP);

has '+profile_name' => (default => 'intapi_java:generate_object_ids');
has 'object_type' => (is => 'ro', isa => 'KnownObjects');
has 'count'  => (is => 'ro', isa => 'Maybe[Int]');
has 'client_id'    => (is => 'ro', isa => 'Id');

around BUILDARGS => sub {
    my ($orig, $class) = (shift, shift);
    my %args = @_;
    
    if (exists $args{signature}) {
        my $signature = delete $args{signature};
        die "unsupported signature: $signature" unless $class->is_signature_supported($signature);

        $args{object_type} //= $object_name_by_signature{$signature};;
    }

    $class->$orig(%args);
};

sub _method { 'sharding/generateObjectIds' }

sub _get_url_params {
    return {};
}

sub _prepare {
    my ($self) = @_;

    my $req_prms = {
        type => $self->_get_signature(),
        count => $self->count(), 
    };
    $req_prms->{client_id} = $self->client_id() if $self->client_id();

    return $req_prms;
}

sub _postprocess {
    my ($self, $result, $error) = @_;
    return $result->{ids};
}


sub _get_signature {
    my $self = shift;
    return $OBJECT_NAME_TO_SIGNATURE_MAP{$self->object_type()}
}


=head2 is_signature_supported
    
    Поддерживается или нет переданная сигнатура идентификатора

=cut 

sub is_signature_supported {
    my ($class, $signature) = @_;

    return $object_name_by_signature{$signature} ? 1 : 0;
}


__PACKAGE__->meta->make_immutable;

1;
