package JavaIntapi::GetAppList;
use Direct::Modern;
use Mouse;

use JSON 'to_json';

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'GET');
has 'client_id' => (is => 'ro', isa => 'Id');

sub _method { 'mobile_app/list' }

sub _get_url_params {
    my ($self) = @_;
    return { client_id => $self->client_id };
}

sub _prepare { undef }

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if ( !$result->{success} || !$result->{result} ) {
        die to_json($result);
    }

    return $result->{result};
}

1;
