
package JavaIntapi::GetAppMobileContent;
use Direct::Modern;
use Mouse;

use JSON 'to_json';
use Yandex::ORM::Types;

extends 'JavaIntapiClientBase';

=head2
	
	Получает информацию о мобильном приложении по url этого приложения, для указанного клиента.
	И сохраняет ее в БД.

    Пример результата:
	https://8080.beta1.intapi.direct.yandex.ru/docs/swagger-ui.html#!/mobile_app/getMobileContent

=cut

has '+http_method' => (default => 'GET');
has 'client_id' => (is => 'ro', isa => 'Id');
has 'url' => (is => 'ro', isa => 'Str');

sub _method { 'mobile_app/mobile_content' }

sub _get_url_params {
    my ($self) = @_;
    return { client_id => $self->client_id, url => $self->url };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if ( !$result->{success} || !$result->{result} ) {
        die to_json($result);
    }

    return $result->{result};
}

1;
