package JavaIntapi::GetBidModifiers;

use Direct::Modern;
use Mouse;
use Yandex::HashUtils qw/hash_grep/;

extends 'JavaIntapiClientBase';

use HierarchicalMultipliers::Base;

=head2

    Получает набор корректировок на указанной кампании/группе объявлений.
    Пример результата:

    {
      "geo_multiplier": {
        "hierarchical_multiplier_id": 430908651,
        "is_enabled": 0,
        "regions": [
          {
            "geo_multiplier_value_id": 430908996,
            "region_id": 17,
            "multiplier_pct": 160
          },
          {
            "geo_multiplier_value_id": 430909001,
            "region_id": 26,
            "multiplier_pct": 200
          },
          {
            "geo_multiplier_value_id": 430908656,
            "region_id": 40,
            "multiplier_pct": 170
          },
          {
            "geo_multiplier_value_id": 430908661,
            "region_id": 225,
            "multiplier_pct": 250
          }
        ]
      },
      "mobile_multiplier": {
        "hierarchical_multiplier_id": 391697341,
        "multiplier_pct": 111,
        "os_type": "ios"
      },
      "desktop_multiplier": {
        "hierarchical_multiplier_id": 391697341,
        "multiplier_pct": 111
      },
      "video_multiplier": {
        "hierarchical_multiplier_id": 391697356,
        "multiplier_pct": 324
      },
      "performance_tgo_multiplier": null,
      "demography_multiplier": {
        "hierarchical_multiplier_id": 391697361,
        "is_enabled": 1,
        "conditions": [
          {
            "demography_multiplier_value_id": 391722626,
            "age": "0-17",
            "gender": "male",
            "multiplier_pct": 125
          },
          {
            "demography_multiplier_value_id": 391722631,
            "age": "45-",
            "gender": null,
            "multiplier_pct": 122
          }
        ]
      },
      "retargeting_multiplier": {
        "hierarchical_multiplier_id": 391722616,
        "is_enabled": 1,
        "conditions": {
          "1427181": {
            "retargeting_multiplier_value_id": 391722621,
            "multiplier_pct": 322
          }
        }
      },
      "success": true
    }

=cut

# Аргументы ручки
has 'campaign_id'  => (is => 'ro', isa => 'Id', required => 1);
has 'adgroup_id'   => (is => 'ro', isa => 'Id');

has '+profile_name' => (default => 'intapi_java:get_bidmodifiers');
has '+warn_if_request_failed' => (default => 0);
has '+http_method' => (default => 'GET');
has '+accept_header' => (default => 'application/json');
has '+log_enabled' => (default => 1);

sub _method { 'bidmodifiers/get' }

sub _get_url_params {
    my ($self) = @_;
    return {
        campaignId  => $self->campaign_id,
        adGroupId   => $self->adgroup_id
    };
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ($result && $result->{success}) {
        # выкидываем корректировки, по которым нет данных (== null  )
        $result = hash_grep {defined $_} $result;
        # при сохранении в perl это поле рассматривается как корректировка и выходит ошибка
        delete $result->{success};

        my $perl_mult = HierarchicalMultipliers::Base::unwrap_expression_multipliers($result);

        return $perl_mult;
    } else {
        die "Can't get bid modifiers from Java IntAPI. Error: " . ($error // '');
    }
}

__PACKAGE__->meta->make_immutable;

1;
