package JavaIntapi::GetCampaignsAssetHashes;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:GetCampaignsAssetHashes');
has '+http_method' => (default => 'POST');
has '+request_timeout' => (default => 90);
has 'campaign_ids' => (is => 'ro', isa => 'ArrayRef[Int]');


sub _method {'bsexport/get-campaigns-asset-hashes'}

sub _get_url_params {undef}

sub _prepare {
    my ($self) = @_;
    return $self->campaign_ids;
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if (defined $result) {
        return $result;
    } else {
        die "error in call_intapi_java('". $self->_method() . "'): " . ($error // '');
    }
}

1;
