package JavaIntapi::GetClientsWithExplicitFeature;

=head1 DESCRIPTION

    Получение списка клиентов, которым явно включена фича.
    Неявное включение на процент не считается.

    Ручка работает небыстро, т.к. ходит по всем шардам.
    Также не стоит использовать, если фичу включают на много клиентов, т.к. никакого чанкования.

    Если ошибиться в названии фичи, кинет эксепшен.

=head1 SYNOPSIS

    my $client_ids = JavaIntapi::GetClientsWithExplicitFeature->new(
            feature_name => 'имя фичи'
        )->call();

    assert_eq($client_ids, [12345, 67890]);

=cut

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:GetClientsWithExplicitFeature');
has '+http_method' => (default => 'GET');

has 'feature_name' => (is => 'ro', isa => 'Str');

sub _method { 'feature_dev/get_clients_with_explicit_feature' }

sub _get_url_params {
    my ($self) = @_;

    return {
        feature_name => $self->feature_name,
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if ( !$result->{success} ) {
        die "error in call_intapi_java('". $self->_method() . "'): " . ($error // '');
    }

    return $result->{result};
}

1;
