package JavaIntapi::GetCryptaSegments;

use JSON;
use Settings;
use Yandex::HTTP;
use Yandex::I18n;
use Yandex::TVM2;
use Yandex::Trace;

use Direct::Modern;

our $INTAPI_REQUEST_TIMEOUT = 15;

our @EXPORT = qw/
    _get_crypta_segments
    /;


sub _get_crypta_segments {
    my ($self) = @_;

    my $profile = Yandex::Trace::new_profile('java_crypta:get_crypta_segments');

    state ($log, $json);
    $log //= Yandex::Log->new(
        no_log => 1,
        use_syslog => 1,
        syslog_prefix => 'INTAPI-JAVA',
        log_file_name => "GetCryptaSegments.log",
    );
    $json //= JSON->new->allow_unknown(1)->allow_blessed(1)->convert_blessed(1);

    my $url = Yandex::HTTP::make_url(
        $Settings::DIRECT_INTAPI_URL . 'targets/crypta/segments',
        {}
    );

    my $trace_id = Yandex::Trace::current_span_id();
    my $trace_header = join(',', map {$_ // 0} $trace_id, Yandex::Trace::generate_traceid(), $trace_id, 0);

    my $ticket = eval{Yandex::TVM2::get_ticket($Settings::TVM2_APP_ID{intapi})} or $log->die("Cannot get ticket for $Settings::TVM2_APP_ID{intapi}: $@");

    $log->out(['GET', $url, 'X-Yandex-Trace:', $trace_header]);

    my $response = Yandex::HTTP::http_parallel_request(GET => { 1 => {
                url => $url
            }},
        timeout => $INTAPI_REQUEST_TIMEOUT,
        log => $log,
        headers => {
            'Accept' => 'application/json',
            'X-Detected-Locale' => _get_lang_for_request(),
            'X-Ya-Service-Ticket' => $ticket,
            'X-Yandex-Trace' => $trace_header
        },
    )->{1};

    my ($result, $error);
    if ($response->{is_success}) {
        utf8::decode($response->{content});
        my $content = $json->decode($response->{content});
        if (!$content->{success}) {
            $error = $content;
        } else {
            $result = $content->{result} if $response->{content};
        }
    } else {
        $error = {
            server_status => $response->{headers}->{Status},
            server_error => 'Server returned an error'
        };
    }

    return $result, $error;
}

sub _get_lang_for_request {
    my %LANG_ALIAS = (ua => 'uk');
    my $lang = Yandex::I18n::current_lang();
    return $LANG_ALIAS{$lang} || $lang;
}

1;

