package JavaIntapi::GetFraudClicks;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:getFraudClicks');
has '+http_method' => (default => 'POST');
has 'order_ids' => (is => 'ro', isa => 'ArrayRef[Int]');
has 'start_date' => (is => 'ro', isa => 'Str');
has 'end_date' => (is => 'ro', isa => 'Str');

sub _method { 'statistic/orders/getFraudClicks' }

sub _get_url_params { undef }

sub _prepare {
	my ($self) = @_;
    return {
    	orderIds => $self->order_ids,
    	startDate => $self->start_date,
    	endDate => $self->end_date
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if ($result && %$result) {
        return {
            fraud_clicks => $result->{fraudClicks},
            fraud_gift_clicks => $result->{giftClicks},
            fraud_shows_general => $result->{fraudShowsGeneral},
            fraud_shows_sophisticated => $result->{fraudShowsSophisticated},
        };
    } else {
        die 'error in call_intapi_java('.$self->_method().'): ' . ($error // '');
    }
}

1;
