package JavaIntapi::GetInternalAdInfo;
use Direct::Modern;
use Mouse;

use JSON qw/to_json/;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:internal_ad_info');
has '+http_method' => (default => 'POST');
has 'shard' => (is => 'ro', isa => 'Int');
has 'bids' => (is => 'ro', isa => 'ArrayRef[Id]');

sub _method { 'internalads/internal_ad_info' }

sub _get_url_params {
    my ($self) = @_;
    return {
        shard => int $self->shard,
    };
}

sub _prepare {
    my ($self) = @_;
    return $self->bids;
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if (!exists $result->{$self->bids->[0]}) {
        die to_json($result);
    }

    return $result;
}

1;
