package JavaIntapi::GetOrderSessionsNumForWeekByOrderId;

use Direct::Modern;
use Mouse;
use Yandex::Validate qw/is_valid_int/;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:getSessionsNumForWeek');
has '+http_method' => (default => 'GET');
has 'order_id' => (is => 'ro', isa => 'Int');

sub _method { 'statistic/order/getSessionsNumForWeek' }

sub _get_url_params {
	my ($self) = @_;
    return { order_id => $self->order_id };
}

sub _prepare { undef }

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if ( !$result->{success} || !is_valid_int($result->{sessionsNumForWeek}, 0)) {
        die "error in call_intapi_java('". $self->_method() . "'): " . ($error // '');
    }

    return $result->{sessionsNumForWeek};
}

1;
