package JavaIntapi::GetOrdersFirstLastDay;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:getOrdersFirstLastDay');
has '+http_method' => (default => 'POST');
has 'order_ids' => (is => 'ro', isa => 'ArrayRef[Int]');

sub _method { 'statistic/orders/getOrdersFirstLastDay' }

sub _get_url_params { undef }

sub _prepare {
    my ($self) = @_;
    return {
        orderIds => $self->order_ids,
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if (defined $result) {
        return $result;
    } else {
        die "error in call_intapi_java('". $self->_method() . "'): " . ($error // '');
    }
}

1;
