package JavaIntapi::GetOrdersSpentToday;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:getOrdersSpentToday');
has '+http_method' => (default => 'POST');
has 'order_ids' => (is => 'ro', isa => 'ArrayRef[Int]');
has 'with_nds' => (is => 'ro', isa => 'Bool');

sub _method { 'statistic/orders/getSpentToday' }

sub _get_url_params {
    my ($self) = @_;
    return { with_nds => $self->with_nds };
}

sub _prepare {
	my ($self) = @_;
    return $self->order_ids;
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if ($result && !$error) {
        return $result;
    } else {
        die 'error in call_intapi_java('.$self->_method().'): ' . ($error // '');
    }
}

1;
