package JavaIntapi::GetOrdersSumSpent;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:getOrdersSumSpent');
has '+http_method' => (default => 'POST');
has 'order_ids' => (is => 'ro', isa => 'ArrayRef[Int]');
has 'periods' => (is => 'ro', isa => 'HashRef');
has 'currency' => (is => 'ro', isa => 'Str');

sub _method { 'statistic/orders/getSumSpent' }

sub _get_url_params {
    my ($self) = @_;
    return { currency => $self->currency };
}

sub _prepare {
	my ($self) = @_;

    my $periods = [map {
            {
                key => $_,
                startDate => $self->periods->{$_}->{from},
                endDate => $self->periods->{$_}->{to}
            }
        } keys %{ $self->periods }
    ];

    return {
        orderIds => $self->order_ids,
        periods => $periods
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if ($result && !$error) {
        return $result;
    } else {
        die 'error in call_intapi_java('.$self->_method().'): ' . ($error // '');
    }
}

1;
