
package JavaIntapi::GetOrganizationsInfo;
use Direct::Modern;
use Mouse;

use JSON 'to_json';
use Yandex::ORM::Types;

extends 'JavaIntapiClientBase';

=head2
	
	Получает информацию об организациях справочника по их пермалинкам.

    Пример результата:
	https://8080.beta1.intapi.direct.yandex.ru/docs/swagger-ui.html#!/organizations-controller/get_info

=cut

has '+profile_name' => (default => 'intapi_java:get_organizations_info');
has '+http_method' => (default => 'POST');
has 'permalinkIds' => (is => 'ro', isa => 'ArrayRef[Int]');
has 'language' => (is => 'ro', isa => 'Str');

sub _method { 'organizations/get_info' }

sub _get_url_params { undef }

sub _prepare {
    my ($self) = @_;
    return {
        permalinkIds => $self->permalinkIds // [],
        language => $self->language // ""
    };
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    die $error if $error;

    if ( !$result->{success} || !$result->{result} ) {
        die to_json($result);
    }

    return $result->{result};
}

1;
