package JavaIntapi::GetPostviewOfflineReportList;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+http_method' => (default => 'GET');
has '+profile_name' => (default => 'intapi_java:get_postview_offline_report_list');
has 'client_id' => (is => 'ro', isa => 'Id');

sub _method { 'client_offline_report/postview/get_list' }

sub _get_url_params {
    my ($self) = @_;
    return { client_id => $self->client_id };
}

sub _prepare {}

sub _postprocess {
    my ($self, $result, $error) = @_;

    if ($result && $result->{reports}) {
        return $result->{reports};
    } else {
        warn "error in call_intapi_java('".$self->_method."'): " . ($error // '');
        return;
    }
}

__PACKAGE__->meta->make_immutable;

1;
