package JavaIntapi::GetRoughForecast;

use Direct::Modern;
use Mouse;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:getRoughForecast');
has '+http_method' => (default => 'POST');
has 'campaign_ids' => (is => 'ro', isa => 'ArrayRef[Int]');
has 'currency' => (is => 'ro', isa => 'Str');

sub _method { 'statistic/campaigns/getRoughForecast' }

sub _get_url_params {
    my ($self) = @_;
    return { currency => $self->currency };
}

sub _prepare {
	my ($self) = @_;
    return $self->campaign_ids;
}

sub _postprocess {
    my ( $self, $result, $error ) = @_;

    if ($result) {
        return $result;
    } else {
        die 'error in call_intapi_java('.$self->_method().'): ' . ($error // '');
    }
}

1;
