package JavaIntapi::GetShowConditionsStatistic;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:get_show_conditions_statistic');
has '+items'  => (required => 1);
has 'show_condition_type' => (is => 'ro', required => 1, isa => enum([qw/phrase relevance_match retargeting dynamic performance/]));

sub _method { 
    my ($self) = @_;
    return join('/', 'statistic', $self->show_condition_type, 'get'); 
}

sub _get_url_params {
    my ($self) = @_;
    return {};
}

my %REQUEST_FIELD_NAMES = (
    phrase => 'phrase_ids',
    relevance_match => 'relevance_match_id',
    retargeting => 'retargeting_condition_ids',
    dynamic => 'dynamic_condition_ids',
    performance => 'performance_filter_ids',
);

sub _prepare {
    my ($self) = @_;
    my $ids_field = $REQUEST_FIELD_NAMES{ $self->show_condition_type };
    die 'incorrect show_condition_type' unless $ids_field;

    my $data = {};
    foreach my $item (@{ $self->items }) {
        next unless ($item->{cid} && $item->{pid} && $item->{id});
        $data->{ $item->{cid} }->{ $item->{pid} }->{ $item->{id} } = 1;
    }

    my @selection_criteria;
    foreach my $cid (keys %$data) {
        foreach my $pid (keys %{ $data->{ $cid } }) {
            if ($self->show_condition_type eq 'relevance_match') {
                push @selection_criteria, map { {campaign_id => $cid, ad_group_id => $pid, $ids_field => $_} } 
                                          keys %{ $data->{ $cid }->{ $pid } };
            } else {
                push @selection_criteria, {
                     campaign_id   => $cid, 
                     ad_group_id   => $pid,
                     $ids_field    => [ keys %{ $data->{ $cid }->{ $pid } } ], 
                };
            }
        }
    }
    return { 
        interval_days => 28, 
        selection_criteria => \@selection_criteria
    };
}

my %RESPONSE_FIELD_NAMES = (
    phrase => 'phrase_id',
    relevance_match => 'relevance_match_id',
    retargeting => 'retargeting_condition_id',
    dynamic => 'dynamic_condition_id',
    performance => 'performance_filter_id',
);

sub _postprocess {
    my ($self, $result, $error) = @_;
    my $id_field = $RESPONSE_FIELD_NAMES{ $self->show_condition_type };
    die 'incorrect show_condition_type' unless $id_field;

    my $statistic = {};
    # суммируем показы (и клики) по баннерам в группе
    foreach my $row (@{ $result // [] }) {
        next unless ($row->{ad_group_id} && $row->{ $id_field });
        foreach my $field (qw/clicks shows eshows context_clicks context_shows/) {
            $statistic->{ $row->{ad_group_id} }->{ $row->{ $id_field } }->{ $field } += ($row->{ $field } || 0);
        }
    }
    return $statistic;
}

__PACKAGE__->meta->make_immutable;

1;
