package JavaIntapi::GetTrafficVolume;

use Direct::Modern;
use Mouse;

use JSON;
use Yandex::ScalarUtils;
use Currencies;
use PlacePrice ();

extends 'JavaIntapiClientBase';

has '+profile_name' => (default => 'intapi_java:get_traffic_volume');
has '+items' => (required => 1);

sub _method {'auction/interpolate'}

sub _get_url_params {
    my ($self) = @_;
    return {};
}

sub _prepare {
    my ($self) = @_;

    my @phrases_bids;
    foreach my $item (@{ $self->items }) {
        push @phrases_bids, {
                domain         => $item->{domain},
                currency_code  => $item->{currency},
                is_exact_match => ($item->{phrase}->{phrase} =~ m/^\s*\"/) ? JSON::true : JSON::false,
                auction_items  => [ map {{
                    amnesty_price  => $_->{amnesty_price},
                    bid            => $_->{bid_price},
                    traffic_volume => $_->{position_ctr_correction},
                };} @{$item->{phrase}->{clickometer}} ],
            };
    }

    return { phrases_bids => \@phrases_bids, };
}

sub _postprocess {
    my ($self, $result, $error) = @_;

    foreach my $i (0 .. $#{$self->items}) {
        my $item = $self->items->[$i];
        if ($error) {
            $item->{phrase}->{nobsdata} = 1;
            $item->{phrase}->{bs_data_exists} = undef;
        } else {
            my $fail_position;
            if ($item->{phrase}->{is_trafaret}) {
                $fail_position = {
                    premium   => { 0 => 1, 1 => 1, 2 => 1, 3 => 1, },
                    guarantee => { 0 => 1, 1 => 1, 2 => 1, 3 => 1, },
                };
            }

            my %uniq;
            $item->{phrase}->{traffic_volume} = {};
            foreach my $auction_item (
                grep { !$uniq{$_->{traffic_volume}}++ }
                    sort { $a->{traffic_volume} == $b->{traffic_volume} ? $a->{bid} <=> $b->{bid} : $a->{traffic_volume} <=> $b->{traffic_volume} }
                        @{$result->[$i]->{auction_items}}
            ) {
                my $traffic_volume = $auction_item->{traffic_volume};
                if ($self->log_enabled) {
                    $self->_log(
                        sprintf "bid id: %s, phrase: %s, traffic_volume: %s, bid_price: %s, amnesty_price: %s",
                            $item->{phrase}->{id}, $item->{phrase}->{phrase}, $traffic_volume, $auction_item->{bid}, $auction_item->{amnesty_price}
                    );
                }
                if ($traffic_volume % 1e4 == 0) {# чтобы дробные X не перезаписывали целые после / 1e4
                    $item->{phrase}->{traffic_volume}->{int($traffic_volume / 1e4)} = {
                        bid_price     => $auction_item->{bid},
                        amnesty_price => $auction_item->{amnesty_price},
                    };
                }

                # для совместимости генерируем старый формат
                if ($item->{phrase}->{is_trafaret} && ( my $p = $PlacePrice::PLACE_BY_POSITION_CTR_CORRECTION{$traffic_volume} )) {
                    $item->{phrase}->{$p->{type}}->[$p->{index}] = {
                        bid_price     => $auction_item->{bid},
                        amnesty_price => $auction_item->{amnesty_price},
                    };
                    delete $fail_position->{$p->{type}}->{$p->{index}};
                    delete $fail_position->{$p->{type}} unless scalar keys %{$fail_position->{$p->{type}}}
                }
            }

            # иногда java-ручка не может расчитать точки по которым мы строим старый формат, поэтому такие позиции
            # считываем недостижимыми
            if ($item->{phrase}->{is_trafaret} && scalar keys %$fail_position) {
                my $max_price_plus_step = (
                    get_currency_constant($item->{currency}, 'MAX_PRICE') + get_currency_constant($item->{currency}, 'AUCTION_STEP')
                ) * 1e6;
                foreach my $type (keys %$fail_position) {
                    foreach my $index (keys %{$fail_position->{$type}}) {
                        $item->{phrase}->{$type}->[$index] = {
                            bid_price     => $max_price_plus_step,
                            amnesty_price => $max_price_plus_step,
                        }
                    }
                }
            }
        }
    }

    return;
}

__PACKAGE__->meta->make_immutable;

1;
